# YOLOv8-seg 部署示例

该示例使用 [yolov8](https://docs.ultralytics.com/models/yolov8/) 提供的 [yolov8s-seg](https://github.com/ultralytics/assets/releases/download/v8.3.0/yolov8s-seg.pt) 预训练权重。

整体步骤如下：

1. 参考 [yolov8](https://docs.ultralytics.com/models/yolov8/) 导出 onnx 文件，也可以使用我们已经导出的 onnx 文件。
2. 把 onnx 转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
3. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
4. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
5. 对 rbo 进行性能测试和精度测试。

**目录**

- [YOLOv8-seg 部署示例](#yolov8-seg-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017_Quantization_100.zip)
2. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/yolov8s-seg.onnx)
3. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/yolov8s-seg_8bit.sg)
4. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/yolov8s-seg.rbo)

## 1. 模型转换

RBCC 支持 ONNX 模型格式作为输入导出 sg，可以从[模型与数据集下载](#0-模型与数据集下载)提供的链接下载 `yolov8s-seg.onnx` 至该文件夹内，也可以选择自行导出 onnx 模型，onnx 模型导出步骤如下：

1. 安装 `ultralytics`:
  
    ```shell
    pip install ultralytics==8.3.218
    ```

2. 在当前目录下执行 `mkdir outputs`，然后下载 [yolov8s-seg.pt](https://github.com/ultralytics/assets/releases/download/v8.3.0/yolov8s-seg.pt) 权重到 `outputs` 文件夹。

3. 执行以下脚本导出 onnx 模型：

    ```shell
    python export_onnx.py outputs/yolov8s-seg.pt outputs/yolov8s-seg.onnx
    ```

onnx 模型导出成功后，我们需要从 onnx 模型导出 sg：

```shell
$ mkdir outputs
$ rbcc parse --onnx outputs/yolov8s-seg.onnx --sg outputs/yolov8s-seg.sg
The version of rbcc installed is 1.2.2
2025-10-27 10:56:02 - RBCC - INFO - Start parse 'outputs/yolov8s-seg.onnx' onnx model.
/opt/miniconda/envs/rbcc/lib/python3.10/site-packages/click/decorators.py:34: UserWarning: Node '/model_10/Resize' stores empty string input for placeholder.
  return f(get_current_context(), *args, **kwargs)
/opt/miniconda/envs/rbcc/lib/python3.10/site-packages/click/decorators.py:34: UserWarning: Node '/model_13/Resize' stores empty string input for placeholder.
  return f(get_current_context(), *args, **kwargs)
2025-10-27 10:56:06 - RBCC - INFO - ONNX model parsed successfully.
2025-10-27 10:56:06 - RBCC - INFO - Model's input  0: name=images, shape=[1, 640, 640, 3], dtype=float32.
2025-10-27 10:56:06 - RBCC - INFO - Model's output 0: name=output0, shape=[1, 116, 8400], dtype=float32.
2025-10-27 10:56:06 - RBCC - INFO - Model's output 1: name=output1, shape=[1, 160, 160, 32], dtype=float32.
SG IR saved in outputs/yolov8s-seg.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

为了提高模型在硬件设备上的推理性能，可以对模型结构进行优化（可选步骤，若其他系列（n\m\l）的模型遇到错误可跳过）：

```shell
python rewriter_sg.py outputs/yolov8s-seg.sg
```

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `COCO2017_Quantization_100.zip` 到该文件夹内。

对量化校准数据集 `COCO2017_Quantization_100.zip` 解压，然后执行：

```shell
$ python quantize_sg.py outputs/yolov8s-seg.sg COCO2017_Quantization_100
Quantize Calibration - Histogram: 100sample [00:04, 20.10sample/s]
```

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/yolov8s-seg_8bit.sg --rbo outputs/yolov8s-seg.rbo --config env.json 
The version of rbcc installed is 1.2.2
2025-10-28 10:13:13 - RBCC - INFO - Start loading 'outputs/yolov8s-seg_8bit.sg'.
2025-10-28 10:13:13 - RBCC - INFO - Loading sg end.
2025-10-28 10:13:13 - RBCC - INFO - Start compiling the model and generate rbo.
2025-10-28 10:13:17 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/yolov8s-seg.rbo'.
```

## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到具有 CAISA 430 芯片上的设备进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
$ python demo.py outputs/yolov8s-seg.rbo ../../imgs/demo.jpg 
INFO: Load model from outputs/yolov8s-seg.rbo
Model Uploading: 100%|███████████████████████████████████████████████| 9.89M/9.89M [00:00<00:00, 20.4MB/s]
[2025-10-28 10:15:59.644] [ INFO ] [Client] Model loading successful from loacl path - Model ID: 985d392f-eac1-43df-bb86-68d3797410e8
[2025-10-28 10:16:00.372] [ INFO ] [Client] Model removed successfully. Model ID: 985d392f-eac1-43df-bb86-68d3797410e8
```

预测结果可通过 `demo_predict.jpg` 文件查看。

### 4.2 精度测试

全数据集精度测试：

| Model            | DataSet         | dtype  | bbox-mAP<sup>val<br>50-95 | mask-mAP<sup>val<br>50-95 |
| ---------------- | --------------- | ------ | ------------------------- | ------------------------- |
| YOLOv8s-seg-pt   | COCO2017(val)   |  fp32  | 44.5                      | 36.7                      |
| YOLOv8s-seg-sg   | COCO2017(val)   |  uint8 | 43.4                      | 36.3                      |
| YOLOv8s-seg-rbo  | COCO2017(val)   |  uint8 | 43.4                      | 36.2                      |

注：上表中的精度采用的是以下中：

```shell
Class     Images  Instances      Box(P          R      mAP50  mAP50-95)     Mask(P          R      mAP50  mAP50-95)
 all       5000      36335      0.693      0.552      0.606      0.445      0.693      0.532      0.578      0.367
```

`Box-mAP50-95` 和 `Mask-mAP50-95` 的结果。

该模型使用 COCO2017 数据集进行精度评估，请参考如下方式下载数据集，

1. 下载 [coco2017labels-segments.zip](https://github.com/ultralytics/assets/releases/download/v0.0.0/coco2017labels-segments.zip)。
2. 下载 [val2017.zip](http://images.cocodataset.org/zips/val2017.zip)。

解压 `coco2017labels-segments.zip` 后文件夹结构如下：

```shell
└── coco/
    ├── annotations
    ├── train2017.txt
    ├── val2017.txt
    ├── test-dev2017.txt
    ├── images
    ├    ├── val2017
    └── labels
```

之后解压 `val2017.zip` 到 images 文件中。

评估方式如下（因为我们使用 `ultralytics` 库进行精度评估，请确保 `ultralytics==8.3.218` 版本对应，否则会导致精度评估报错)：

```shell
python eval_acc.py outputs/yolov8s-seg.rbo coco
```

参数介绍：

- 第一个参数 `outputs/yolov8s-seg.rbo` 是待评估精度的模型文件，支持 pt、sg 和 rbo 三种模型格式。
- 第二个参数 `coco` 是 COCO2017 segments 数据集文件夹路径。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
python eval_acc.py outputs/yolov8s-seg_8bit.sg coco
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)。
