# YOLOv5s 部署示例

该示例使用 [yolov5](https://github.com/ultralytics/yolov5) 提供的 `yolov5s` 预训练权重。

整体步骤如下：

1. 参考 [yolov5](https://github.com/ultralytics/yolov5) 导出 YOLOv5s onnx 文件，也可以使用我们已经导出的 onnx 文件。
2. 把 onnx 模型转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
3. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
4. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
5. 对 rbo 进行性能测试和精度测试。

> [yolov5s](https://github.com/ultralytics/yolov5) release 提供的 onnx 文件默认是 fp16 数据类型，目前 rbcc 还未支持 fp16 onnx 模型。

**目录**

- [YOLOv5s 部署示例](#yolov5s-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
    - [1.1 模型优化](#11-模型优化)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
    - [3.1 端到端编译](#31-端到端编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017_Quantization_100.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017.zip)
3. [onnx 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/yolov5s.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/yolov5s_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/yolov5s.rbo)

## 1. 模型转换

RBCC 支持 ONNX 模型格式作为输入导出 sg，可以从[模型与数据集下载](#0-模型与数据集下载)提供的链接下载 `yolov5s.onnx` 至 `outputs` 文件夹内（需要新建该文件夹），也可以选择自行导出 onnx 模型，导出 onnx 的流程如下：

```shell
$ git clone https://github.com/ultralytics/yolov5
$ cd yolov5
$ pip install -r requirements.txt
# 请提前下载好 yolov5s.pt（https://github.com/ultralytics/yolov5/releases/download/v7.0/yolov5s.pt）权重文件到 yolov5 目录下.
$ python export.py --weights yolov5s.pt --simplify --include onnx
$ mkdir outputs
$ cp yolov5s.onnx ../outputs/
$ cd ..
```

根据 onnx 解析 sg 的流程如下：

```shell
$ rbcc parse --onnx outputs/yolov5s.onnx --sg outputs/yolov5s.sg
The version of rbcc installed is 1.2.0
2025-04-24 14:14:12 - RBCC - INFO - Start parse 'yolov5s.onnx' onnx model.
2025-04-24 14:14:16 - RBCC - INFO - ONNX model parsed successfully.
2025-04-24 14:14:16 - RBCC - INFO - Model's input  0: name=images, shape=[1, 640, 640, 3], dtype=float32.
2025-04-24 14:14:16 - RBCC - INFO - Model's output 0: name=output0, shape=[1, 25200, 85], dtype=float32.
SG IR saved in outputs/yolov5s.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

### 1.1 模型优化

为了提高模型在硬件设备上的推理性能，可以对模型图结构进行优化：

```shell
python rewriter_sg.py outputs/yolov5s.sg config/yolov5s.yaml outputs/yolov5s.sg 
```

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前，请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `COCO2017_Quantization_100.zip` 到该文件夹内。

对量化校准数据集 `COCO2017_Quantization_100.zip` 解压，然后使用如下脚本进行量化：

```shell
$ python quantize_sg.py outputs/yolov5s.sg COCO2017_Quantization_100
Quantize Calibration - Histogram: 100sample [00:10,  9.23sample/s]
```

> 为了减小模型的量化损失，我们采用了 `WeightReconQunatizer` 量化方法，该方法可以通过学习一组自适应的舍入参数，来优化每个权重的舍入方式。并且对卷积算子采用 Per—Channel 方式量化。具体设置请参考 rbcc 手册量化部分。
> 该示例可用于您集成到代码环境中的参考。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/yolov5s_8bit.sg --rbo outputs/yolov5s.rbo
The version of rbcc installed is 1.2.0
2025-04-16 12:07:57 - RBCC - INFO - Start loading 'outputs/yolov5s_8bit.sg'.
2025-04-16 12:07:57 - RBCC - INFO - Loading sg end.
2025-04-16 12:07:57 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-16 12:08:14 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/yolov5s.rbo'.
```

> 该模型不支持编译时修改输入 shape，若有需求，请在导出 onnx 文件时修改输入 shape。

### 3.1 端到端编译

通过 rbpy API，我们可以把前后处理和主干网络连接在一起编译生成端到端的 rbo，此示例用法如下：

```shell
python compile_end2end.py outputs/yolov5s_8bit.sg outputs/yolov5s_e2e.rbo
```

此脚本把 1080p 图像作为输入，前处理和后处理都在 rbo 中。


## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用环境安装](../rbo_exe.md)。

使用 scp 将 outputs/yolov5s.rbo 上传到 CAISA 430 设备可访问的路径。

```shell
scp outputs/yolov5s.rbo root@192.168.12.169:/data
# scp outputs/yolov5s_e2e.rbo root@192.168.12.169:/data
```

### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
python demo.py /data/yolov5s.rbo ../../imgs/demo.jpg
```

若想测试端到端流程的 rbo，执行如下命令：

```shell
python demo.py /data/yolov5s_e2e.rbo ../../imgs/demo.jpg --e2e
```

结果如下：

![img](./demo_predict.jpg)

### 4.2 精度测试

全数据集精度测试：

| Model       | DataSet        | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | -------------- | ------ | -------------------- | ----------------- |
| YOLOv5s     | COCO2017(5k)   | fp32   | 37.4                 |  56.7             |
| YOLOv5s-sg  | COCO2017(5k)   | uint8  | 36.8                 |  56.2             |
| YOLOv5s-rbo | COCO2017(5k)   | uint8  | 36.8                 |  56.2             |

部分数据集精度测试（前 500 imgs）：

| Model       | DataSet         | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | --------------- | ------ | -------------------- | ----------------- |
| YOLOv5s     | COCO2017(500)   | fp32   | 42.3                 |  61.3             |
| YOLOv5s-sg  | COCO2017(500)   | uint8  | 41.8                 |  61.4             |
| YOLOv5s-rbo | COCO2017(500)   | uint8  | 41.7                 |  61.4             |

该模型使用 COCO2017 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── COCO2017
    ├── val2017                 # 测试图片, 共 5000 张
    └── annotations             # 标签
```

评估方式如下：

```shell
$ python ../../tools/eval_coco.py /data/yolov5s.rbo --preprocess-py preprocess.py --data ~/datasets/COCO2017 --device-id 0 --yolo-coco --eval-nums 500
INFO: Init Runner.
INFO: Load model from /data/yolov5s.rbo
Heartbeat manager started
Model uploaded successfully. Model ID: 2a656c37-2611-4d69-a69c-8bd5df9dd044
INFO: Load preprocess.
INFO: Load dataset.
loading annotations into memory...
Done (t=0.91s)
creating index...
index created!
INFO: Start inference.
Eval in COCO2017: 100%|██████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 500/500 [11:07<00:00,  1.34s/img]
Model remove successfully. Model ID: 2a656c37-2611-4d69-a69c-8bd5df9dd044
INFO: COCO evaluate....
Loading and preparing results...
DONE (t=0.47s)
creating index...
index created!
Running per image evaluation...
Evaluate annotation type *bbox*
DONE (t=10.64s).
Accumulating evaluation results...
DONE (t=2.24s).
 Average Precision  (AP) @[ IoU=0.50:0.95 | area=   all | maxDets=100 ] = 0.417
 Average Precision  (AP) @[ IoU=0.50      | area=   all | maxDets=100 ] = 0.614
 Average Precision  (AP) @[ IoU=0.75      | area=   all | maxDets=100 ] = 0.455
 Average Precision  (AP) @[ IoU=0.50:0.95 | area= small | maxDets=100 ] = 0.232
 Average Precision  (AP) @[ IoU=0.50:0.95 | area=medium | maxDets=100 ] = 0.463
 Average Precision  (AP) @[ IoU=0.50:0.95 | area= large | maxDets=100 ] = 0.535
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets=  1 ] = 0.345
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets= 10 ] = 0.543
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets=100 ] = 0.589
 Average Recall     (AR) @[ IoU=0.50:0.95 | area= small | maxDets=100 ] = 0.407
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=medium | maxDets=100 ] = 0.639
 Average Recall     (AR) @[ IoU=0.50:0.95 | area= large | maxDets=100 ] = 0.703
INFO: box@map 0.41745892329019707
```

参数介绍：

- `--preprocess-py`：预处理和后处理脚本。
- `--data`：COCO2017 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--yolo-coco`：表示使用 80 个类别的精度评价。
- `--eval-nums`：指定数据集的大小，COCO2017 验证数据集共有 5000 张图片。
- `--conf`：nms 分数阈值参数。


若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python ../../tools/eval_coco.py outputs/yolov5s_8bit.sg --preprocess-py preprocess.py --data ~/datasets/COCO2017/ --device-id 0 --yolo-coco --eval-nums 500
INFO: Init Runner.
INFO: Load model from outputs/yolov5s_8bit.sg
INFO: Load preprocess.
INFO: Load dataset.
loading annotations into memory...
Done (t=0.77s)
creating index...
index created!
INFO: Start inference.
Eval in COCO2017: 100%|███████████████████████████████████████████████████████████████████████████████████████████████████████████| 500/500 [05:50<00:00,  1.43img/s]
INFO: COCO evaluate....
Loading and preparing results...
DONE (t=0.38s)
creating index...
index created!
Running per image evaluation...
Evaluate annotation type *bbox*
DONE (t=5.28s).
Accumulating evaluation results...
DONE (t=1.20s).
 Average Precision  (AP) @[ IoU=0.50:0.95 | area=   all | maxDets=100 ] = 0.418
 Average Precision  (AP) @[ IoU=0.50      | area=   all | maxDets=100 ] = 0.614
 Average Precision  (AP) @[ IoU=0.75      | area=   all | maxDets=100 ] = 0.458
 Average Precision  (AP) @[ IoU=0.50:0.95 | area= small | maxDets=100 ] = 0.231
 Average Precision  (AP) @[ IoU=0.50:0.95 | area=medium | maxDets=100 ] = 0.459
 Average Precision  (AP) @[ IoU=0.50:0.95 | area= large | maxDets=100 ] = 0.544
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets=  1 ] = 0.344
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets= 10 ] = 0.541
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets=100 ] = 0.588
 Average Recall     (AR) @[ IoU=0.50:0.95 | area= small | maxDets=100 ] = 0.405
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=medium | maxDets=100 ] = 0.639
 Average Recall     (AR) @[ IoU=0.50:0.95 | area= large | maxDets=100 ] = 0.706
INFO: box@map 0.4181343327963698
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)