# YOLOv3 部署示例

该示例使用 [bubbliiiing/yolo3-pytorch](https://github.com/bubbliiiing/yolo3-pytorch/tree/master) 提供的 `yolov3` 预训练权重。

整体步骤如下：

1. 参考 [bubbliiiing/yolo3-pytorch](https://github.com/bubbliiiing/yolo3-pytorch/tree/master) 导出 YOLOv3 onnx 文件，也可以使用我们已经导出的 onnx 文件。
2. 把 onnx 模型转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
3. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
4. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
5. 对 rbo 进行性能测试和精度测试。

**目录**

- [YOLOv3 部署示例](#yolov3-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
    - [3.1 端到端编译](#31-端到端编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)
    
## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017_Quantization_100.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017.zip)
3. [onnx 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/yolov3.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/yolov3_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/yolov3.rbo)

## 1. 模型转换

RBCC 支持 ONNX 模型格式作为输入导出 sg, 从[模型与数据集下载](#0-模型与数据集下载)提供的链接下载 `yolov3.onnx` 至该文件夹内，使用 `make outputs` 新建 outputs 文件夹。

若想重新导出 onnx 模型，步骤如下：

```shell
mkdir outputs
git clone https://github.com/bubbliiiing/yolo3-pytorch.git
# 下载 https://github.com/bubbliiiing/yolo3-pytorch/releases/download/v1.0/yolo_weights.pth 权重到 outputs/yolo_weights.pth
OLD_PYTHONPATH=${PYTHONPATH}
export YOLOV3_ROOT=yolo3-pytorch
export PYTHONPATH=${PYTHONPATH}:${YOLOV3_ROOT}
python export_onnx.py \
    outputs/yolo_weights.pth \
    outputs/yolov3.onnx
# PYTHONPATH 改回原来的环境变量
export PYTHONPATH=$OLD_PYTHONPATH
```

从 onnx 模型导出 sg：

```shell
$ rbcc parse --onnx outputs/yolov3.onnx
The version of rbcc installed is 1.2.0
2025-05-14 17:00:29 - RBCC - INFO - Start parse 'outputs/yolov3.onnx' onnx model.
2025-05-14 17:00:34 - RBCC - INFO - ONNX model parsed successfully.
2025-05-14 17:00:34 - RBCC - INFO - Model's input  0: name=images, shape=[1, 416, 416, 3], dtype=float32.
2025-05-14 17:00:34 - RBCC - INFO - Model's output 0: name=output, shape=[1, 13, 13, 255], dtype=float32.
2025-05-14 17:00:34 - RBCC - INFO - Model's output 1: name=664, shape=[1, 26, 26, 255], dtype=float32.
2025-05-14 17:00:34 - RBCC - INFO - Model's output 2: name=692, shape=[1, 52, 52, 255], dtype=float32.
SG IR saved in outputs/yolov3.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。并且我们提供了两种量化方法供用户选择：命令行方式和 Python API 接口。您可以根据实际需求灵活选择适合的方式完成对 sg 的量化操作。在进行量化前请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `COCO2017_Quantization_100.zip` 到该文件夹内。

对量化校准数据集 `COCO2017_Quantization_100.zip` 解压，然后使用如下脚本进行量化：

```shell
$ python quantize_sg.py outputs/yolov3.sg COCO2017_Quantization_100/
Quantize Calibration - Histogram: 100sample [00:10,  9.97sample/s]
```

该模型量化使用 [AdaRound](https://arxiv.org/pdf/2004.10568) 和混合量化（对最后 2 层 Conv 提升到 16-bit ）来提升模型量化精度。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/yolov3_8bit.sg --rbo outputs/yolov3.rbo --config env.json
The version of rbcc installed is 1.2.0
2025-05-15 09:30:20 - RBCC - INFO - Start loading 'outputs/yolov3_8bit.sg'.
2025-05-15 09:30:20 - RBCC - INFO - Loading sg end.
2025-05-15 09:30:20 - RBCC - INFO - Start compiling the model and generate rbo.
2025-05-15 09:30:26 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/yolov3.rbo'.
```

### 3.1 端到端编译

通过 rbpy API，我们可以把前后处理和主干网络连接在一起编译生成端到端的 rbo，此示例用法如下：

```shell
python compile_end2end.py outputs/yolov3_8bit.sg outputs/yolov3_e2e.rbo --config env.json
```

此脚本把 1080p 图像作为输入，前处理和后处理都在 rbo 中。

## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用环境安装](../rbo_exe.md)。

### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
python demo.py outputs/yolov3.rbo ../../imgs/demo.jpg
```

若想测试端到端流程的 rbo，执行如下命令：

```shell
python demo.py outputs/yolov3_e2e.rbo ../../imgs/demo.jpg --e2e
```

### 4.2 精度测试

全数据集精度测试：

| Model       | DataSet        | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | -------------- | ------ | -------------------- | ----------------- |
| YOLOv3      | COCO2017(5k)   | fp32   | 37.6                 |  64.9             |
| YOLOv3-sg   | COCO2017(5k)   | uint8  | 37.7                 |  65.0             |
| YOLOv3-rbo  | COCO2017(5k)   | uint8  | 37.7                 |  65.1             |

部分数据集精度测试（前 500 imgs）：

| Model       | DataSet        | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | -------------- | ------ | -------------------- | ----------------- |
| YOLOv3      | COCO2017(500)  | fp32   | 41.7                 | 69.1              |
| YOLOv3-sg   | COCO2017(500)  | uint8  | 41.8                 | 69.1              |
| YOLOv3-rbo  | COCO2017(500)  | uint8  | 41.5                 | 69.1              |

该模型使用 COCO2017 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── COCO2017
    ├── val2017                 # 测试图片, 共 5000 张
    └── annotations             # 标签
```

评估方式如下：

```shell
$ python ../../tools/eval_coco.py outputs/yolov3.rbo --preprocess-py preprocess.py --data ./COCO2017 --device-id 0 --yolo-coco
INFO: Init Runner.
INFO: Load model from outputs/yolov3.rbo
Model Uploading: 100%|██████████████████████████████████████████████████████████████████████████| 10.1M/10.1M [00:00<00:00, 15.6MB/s]
[2025-11-18 11:16:23.094] [ INFO ] [Client] Model loading successful from loacl path - Model ID: b8678ebc-ae6d-459e-8b2c-c05ce0c03d91
INFO: Load preprocess.
INFO: Load dataset.
loading annotations into memory...
Done (t=0.92s)
creating index...
index created!
INFO: Start inference.
Eval in COCO2017: 100%|████████████████████████████████████████████████████| 5000/5000 [15:40<00:00,  5.31img/s]
Model remove successfully. Model ID: b8678ebc-ae6d-459e-8b2c-c05ce0c03d91
INFO: COCO evaluate....
Loading and preparing results...
DONE (t=2.14s)
creating index...
index created!
Running per image evaluation...
Evaluate annotation type *bbox*
DONE (t=71.80s).
Accumulating evaluation results...
DONE (t=8.91s).
 Average Precision  (AP) @[ IoU=0.50:0.95 | area=   all | maxDets=100 ] = 0.377
 Average Precision  (AP) @[ IoU=0.50      | area=   all | maxDets=100 ] = 0.651
 Average Precision  (AP) @[ IoU=0.75      | area=   all | maxDets=100 ] = 0.397
 Average Precision  (AP) @[ IoU=0.50:0.95 | area= small | maxDets=100 ] = 0.221
 Average Precision  (AP) @[ IoU=0.50:0.95 | area=medium | maxDets=100 ] = 0.421
 Average Precision  (AP) @[ IoU=0.50:0.95 | area= large | maxDets=100 ] = 0.532
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets=  1 ] = 0.297
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets= 10 ] = 0.477
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets=100 ] = 0.524
 Average Recall     (AR) @[ IoU=0.50:0.95 | area= small | maxDets=100 ] = 0.354
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=medium | maxDets=100 ] = 0.571
 Average Recall     (AR) @[ IoU=0.50:0.95 | area= large | maxDets=100 ] = 0.670
INFO: box@map 0.3771824335742497
[2025-11-18 11:26:52.785] [ INFO ] [Client] Model removed successfully. Model ID: b8678ebc-ae6d-459e-8b2c-c05ce0c03d91
```

参数介绍：

- `--preprocess-py`：预处理和后处理脚本。
- `--data`：COCO2017 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--yolo-coco`：表示使用 80 个类别的精度评价。
- `--eval-nums`：指定数据集的大小，COCO2017 验证数据集共有 5000 张图片。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python ../../tools/eval_coco.py outputs/yolov3.sg --data ./COCO2017 --preprocess-py preprocess.py --device-id 0 --yolo-coco
INFO: Init Runner.
INFO: Load model from outputs/yolov3.sg
INFO: Load preprocess.
INFO: Load dataset.
loading annotations into memory...
Done (t=0.88s)
creating index...
index created!
INFO: Start inference.
Eval in COCO2017: 100%|███████████████████████████████████████| 5000/5000 [05:27<00:00, 15.28img/s]
INFO: COCO evaluate....
Loading and preparing results...
DONE (t=3.48s)
creating index...
index created!
Running per image evaluation...
Evaluate annotation type *bbox*
DONE (t=74.49s).
Accumulating evaluation results...
DONE (t=9.03s).
 Average Precision  (AP) @[ IoU=0.50:0.95 | area=   all | maxDets=100 ] = 0.376
 Average Precision  (AP) @[ IoU=0.50      | area=   all | maxDets=100 ] = 0.649
 Average Precision  (AP) @[ IoU=0.75      | area=   all | maxDets=100 ] = 0.396
 Average Precision  (AP) @[ IoU=0.50:0.95 | area= small | maxDets=100 ] = 0.223
 Average Precision  (AP) @[ IoU=0.50:0.95 | area=medium | maxDets=100 ] = 0.418
 Average Precision  (AP) @[ IoU=0.50:0.95 | area= large | maxDets=100 ] = 0.526
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets=  1 ] = 0.296
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets= 10 ] = 0.478
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=   all | maxDets=100 ] = 0.524
 Average Recall     (AR) @[ IoU=0.50:0.95 | area= small | maxDets=100 ] = 0.354
 Average Recall     (AR) @[ IoU=0.50:0.95 | area=medium | maxDets=100 ] = 0.570
 Average Recall     (AR) @[ IoU=0.50:0.95 | area= large | maxDets=100 ] = 0.666
INFO: box@map 0.3763741208058272
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)
