# Unet 部署示例

该示例使用的是 [mmsegmentation](https://github.com/open-mmlab/mmsegmentation.git) 项目的  [fcn_unet_s5-d16_4x4_512x1024_160k_cityscapes_20211210_145204-6860854e.pth](https://download.openmmlab.com/mmsegmentation/v0.5/unet/fcn_unet_s5-d16_4x4_512x1024_160k_cityscapes/fcn_unet_s5-d16_4x4_512x1024_160k_cityscapes_20211210_145204-6860854e.pth) 权重，并通过 [mmdeploy](https://github.com/open-mmlab/mmdeploy.git) 项目导出 ONNX 文件。


整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [Unet 部署示例](#unet-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#41-精度测试)
    - [4.2 性能测试](#42-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准与测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/cityscapes.zip)
3. [onnx 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/unet.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/unet_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/unet.rbo)

## 1. 模型转换

导出 onnx 模型：

```shell
$ git clone https://github.com/open-mmlab/mmsegmentation.git
$ git clone https://github.com/open-mmlab/mmdeploy.git
$ cd mmdeploy
$ python tools/deploy.py \
    configs/mmseg/segmentation_onnxruntime_static-1024x2048.py \
    ../mmsegmentation/configs/unet/unet-s5-d16_fcn_4xb4-160k_cityscapes-512x1024.py \
    ./fcn_unet_s5-d16_4x4_512x1024_160k_cityscapes_20211210_145204-6860854e.pth \
    ../mmsegmentation/demo/demo.jpg \
    --work-dir onnx_model \
    --device cpu 
$ onnxsim onnx_model/end2end.onnx ../unet.onnx
$ cd ..
```

请先用 open-mmlab 推荐的环境先导出 onnx，再切换到 RBCC 环境中进行模型转换和编译。

把 onnx 模型转换成 sg：

```shell
$ mkdir outputs
$ mv unet.onnx outputs/
$ rbcc parse --onnx outputs/unet.onnx --sg outputs/unet.sg 
The version of rbcc installed is 1.2.0
2025-04-27 15:02:23 - RBCC - INFO - Start parse 'outputs/unet.onnx' onnx model.
2025-04-27 15:02:54 - RBCC - INFO - ONNX model parsed successfully.
2025-04-27 15:02:54 - RBCC - INFO - Model's input  0: name=input, shape=[1, 1024, 2048, 3], dtype=float32.
2025-04-27 15:02:54 - RBCC - INFO - Model's output 0: name=output, shape=[1, 1, 1024, 2048], dtype=int64.
SG IR saved in outputs/unet.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 50 个样本，作为量化校准数据集。在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载数据集。

对数据集 `cityscapes.zip` 解压，然后对 sg 进行量化：

```shell
$ python quantize_sg.py outputs/unet.sg cityscapes
Quantize Calibration - Histogram: 100%|███████████████████████| 50/50 [00:28<00:00,  1.76sample/s]
```

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/unet_8bit.sg --rbo outputs/unet.rbo
The version of rbcc installed is 1.2.0
2025-04-27 15:41:05 - RBCC - INFO - Start loading 'outputs/unet_8bit.sg'.
2025-04-27 15:41:05 - RBCC - INFO - Loading sg end.
2025-04-27 15:41:05 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-27 15:41:10 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/unet.rbo'.
```

## 4. 模型测试

成功编译生成 rbo 后，我们需要在 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

### 4.1 精度测试

| Model   | DataSet          |  fp32@mIoU    |  sg-int8@mIoU | rbo-int8@mIoU    |
| ------- | ---------------- | ------------- | ------------- | ---------------- |
| Unet    | CityScacpes(500) |  69.10        |  68.84        | 68.84            |

该模型使用 CityScacpes 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── cityscapes
    ├── test_dataset    
    ├── leftImg8bit            
    └── gtFine 
```

评估方式如下：

```shell
# scp rbo 到硬件设备上
$ scp outputs/unet.rbo root@192.168.12.169:/data
$ python eval_acc.py /data/unet.rbo --data ./cityscapes --device-id 0 --eval-nums 500
```

> 评估前，确保 unet.rbo 已经 scp 到 430 系列盒子上，并且容器是可以访问到的路径。

参数介绍：

- `--data`：数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--eval-nums`：指定数据集的大小。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
python eval_acc.py outputs/unet_8bit.sg --data ./cityscapes --device-id 0 --eval-nums 500
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.2 性能测试

参考 [rbo 性能测试](../rbo_perf.md)