# SENet 部署示例

该示例使用 [SENet-Caffe](https://github.com/shicai/SENet-Caffe) 权重。

整体步骤如下：

1. 把 Caffe 模型转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 RBCC 量化 sg 得到 int8 sg。
3. 使用 RBCC 对 int8 sg 进行编译生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [SENet 部署示例](#senet-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#41-精度测试)
    - [4.2 性能测试](#42-性能测试)


## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/imagenet2012_Quantization_200.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/imagenet2012_5k.zip)
3. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/senet50_8bit.sg)
4. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/senet50.rbo)

## 1. 模型转换

RBCC 支持从 Caffe 模型导出 sg。

1. 下载对应 caffe 模型的 `se_resnet_50_v1_deploy.prototxt` 和 `se_resnet_50_v1.caffemodel` 到 outputs 文件夹，
2. 把 `se_resnet_50_v1_deploy.prototxt` 修改成和 caffemodel 同名。
3. 修改 `se_resnet_50_v1.prototxt` 的输入为 `224x224`，如：

```shell
input_shape { 
  dim: 1
  dim: 3
  dim: 225
  dim: 225
}
```

修改为：

```shell
input_shape { 
  dim: 1
  dim: 3
  dim: 224
  dim: 224
}
```

转换生成 sg：

```shell
$ rbcc parse --caffe outputs/se_resnet_50_v1.prototxt --sg outputs/senet50.sg
The version of rbcc installed is 1.2.0
2025-04-29 16:54:55 - RBCC - INFO - Start parse caffe model.
2025-04-29 16:55:03 - RBCC - INFO - Caffe model parsed successfully.
2025-04-29 16:55:03 - RBCC - INFO - Model's input  0: name=data, shape=[1, 224, 224, 3], dtype=float32.
2025-04-29 16:55:03 - RBCC - INFO - Model's output 0: name=prob, shape=[1, 1000, 1, 1], dtype=float32.
SG IR saved in outputs/senet50.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载量化校准数据集。

对量化校准数据集 `imagenet2012_Quantization_200.zip` 解压，然后执行：

```shell
$ python quantize_sg.py outputs/senet50.sg imagenet2012_Quantization_200/
Quantize Calibration - Histogram: 200sample [00:23,  8.63sample/s]
```

> 该示例可用于您集成到代码环境中的参考。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/senet50_8bit.sg --rbo outputs/senet50.rbo --config env.json 
The version of rbcc installed is 1.2.0
2025-04-29 17:08:29 - RBCC - INFO - Start loading 'outputs/senet50_8bit.sg'.
2025-04-29 17:08:29 - RBCC - INFO - Loading sg end.
2025-04-29 17:08:29 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-29 17:08:33 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/senet50.rbo'.
```

`--config env.json` 指定编译优化项，使用后模型性能更佳。

## 4. 模型测试

成功编译生成 rbo 后，我们需要在 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用文档](../rbo_exe.md)。

### 4.1 精度测试

ImageNet-5K 数据集测试结果如下：

| Model            | DataSet       |  Dtype   | Acc@Top-1  | Acc@Top-5 |
| ---------------- | ------------- | -------- | ---------- | --------- |
| se_resnet50      | ImageNet(5K)  |  fp32    | 77.94      | 94.10     |
| se_resnet50-sg   | ImageNet(5K)  |  uint8   | 77.70      | 93.90     |
| se_resnet50-rbo  | ImageNet(5K)  |  uint8   | 77.80      | 93.94     |

该模型使用 ImageNet 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，解压后文件结构如下：

```shell
└── imagenet2012_5k
    ├── xxx.JPEG                # 测试图片, 共 5000 张
    └── val.txt                 # 图片分类标签
```

评估方式如下：

```shell
# scp rbo 到硬件设备上
$ scp outputs/senet50.rbo root@192.168.12.169:/data
$ python ../../tools/eval_imagenet.py /data/senet50.rbo --preprocess-py preprocess.py --data ~/datasets/imagenet2012_5k/ --device-id 0 --batch-size 1
INFO: Init Runner.
INFO: Load model from /data/senet50.rbo
INFO: connect to 192.168.12.169:50052
Model uploaded successfully. Model ID: 00b1ed7375a50bd6af3617809a642edf
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in ImageNet-1K: 100%|███████████████████████████████| 5000/5000 [01:58<00:00, 42.10img/s]
Top1-Acc: 77.80, Top5-Acc: 93.94
```

> 前面步骤中 rbo 输入的 batch 默认为 1，故这里我们只能指定 batch 为 1

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python ../../tools/eval_imagenet.py outputs/senet50_8bit.sg --data ~/datasets/imagenet2012_5k/ --preprocess-py preprocess.py --device-id 0 --batch-size 32
INFO: Init Runner.
INFO: Load model from outputs/senet50_8bit.sg
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in ImageNet-1K: 100%|██████████████████████████████████████████| 157/157 [00:26<00:00,  5.96img/s]
Top1-Acc: 77.70, Top5-Acc: 93.90
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.2 性能测试

参考 [rbo 性能测试](../rbo_perf.md)。
