# PPOCR-Det 部署示例

该示例来自 [PaddleOCR](https://github.com/PaddlePaddle/PaddleOCR) 项目, 权重使用的是 [ch_PP-OCRv4_det_infer.tar](https://paddleocr.bj.bcebos.com/PP-OCRv4/chinese/ch_PP-OCRv4_det_infer.tar)。

整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [PPOCR-Det 部署示例](#ppocr-det-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#41-精度测试)
    - [4.2 性能测试](#42-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准与测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/icdar2019.zip)
2. [onnx 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/ppocr_det.onnx)
3. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/ppocr_det_8bit.sg)
4. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/ppocr_det.rbo)

## 1. 模型转换

导出 onnx 模型：

```shell
# 开始前请先提前下载好模型权重：https://paddleocr.bj.bcebos.com/PP-OCRv4/chinese/ch_PP-OCRv4_det_infer.tar 并解压到当前目录下。
$ pip install paddlepaddle==2.6.2 paddle2onnx==1.3.1 pyclipper shapely
$ mkdir outputs
$ paddle2onnx --model_dir ./ch_PP-OCRv4_det_infer \
    --model_filename inference.pdmodel \
    --params_filename inference.pdiparams \
    --save_file outputs/ppocr_det.onnx \
    --opset_version 11 \
    --enable_onnx_checker True
$ onnxsim outputs/ppocr_det.onnx outputs/ppocr_det.onnx --input-shape 1,3,544,960
```

导出 sg：

```shell
$ rbcc parse --onnx outputs/ppocr_det.onnx --sg outputs/ppocr_det.sg 
The version of rbcc installed is 1.2.0
2025-04-27 18:47:53 - RBCC - INFO - Start parse 'outputs/ppocr_det.onnx' onnx model.
2025-04-27 18:47:57 - RBCC - INFO - ONNX model parsed successfully.
2025-04-27 18:47:57 - RBCC - INFO - Model's input  0: name=x, shape=[1, 544, 960, 3], dtype=float32.
2025-04-27 18:47:57 - RBCC - INFO - Model's output 0: name=sigmoid_0_tmp_0, shape=[1, 544, 960, 1], dtype=float32.
SG IR saved in outputs/ppocr_det.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从数据集中随机抽取 50 个样本，作为量化校准数据集，在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载数据集。

对数据集 `icdar2019.zip` 解压，然后进行量化：

```shell
$ python quantize_sg.py outputs/ppocr_det.sg icdar2019/quantset
Quantize Calibration - Histogram: 100sample [00:04, 2.56sample/s]
```

> 为了减小模型权重在量化过程中因四舍五入导致的量化损失，采用了 `WeightReconQunatizer` 量化方法，该方法可以通过学习一组自适应的舍入参数，来优化每个权重的舍入方式。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/ppocr_det_8bit.sg --rbo outputs/ppocr_det.rbo
The version of rbcc installed is 1.2.0
2025-04-27 18:10:49 - RBCC - INFO - Start loading 'outputs/ppocr_det_8bit.sg'.
2025-04-27 18:10:49 - RBCC - INFO - Loading sg end.
2025-04-27 18:10:49 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-27 18:10:50 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/ppocr_det.rbo'.
```

## 4. 模型测试

成功编译生成 rbo 后，我们需要在 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

### 4.1 精度测试

| Model         | DataSet   | dtype |  fp32@F-Score |  fp32@Precision |
| -----------   | ----------| ----- | ------------- | --------------- |
| PPOCR-Det     | ICDAR2019 | fp32  | 57.48         | 71.50           | 
| PPOCR-Det-sg  | ICDAR2019 | uint8 | 56.77         | 71.64           |
| PPOCR-Det-rbo | ICDAR2019 | uint8 | 56.65         | 71.45           |

该模型使用 icdar2019 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── icdar2019
    ├── quantset                # 量化集
    ├── train_full_images_0     # 测试集图像              
    └── train_full_labels.json  # 测试集标签
```

评估方式如下：

```shell
# scp rbo 到硬件设备上
$ scp outputs/ppocr_det.rbo root@192.168.12.169:/data
python eval_acc.py /data/ppocr_det.rbo --data ./icdar2019 --device-id 0
```

> 评估前，确保 ppocr_det.rbo 已经 scp 到 430 系列盒子上，并且容器是可以访问到的路径。

参数介绍：

- `--data`：数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
python eval_acc.py outputs/ppocr_det_8bit.sg --data ./icdar2019 --device-id 0
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.2 性能测试

参考 [rbo 性能测试](../rbo_perf.md)