import cv2
import math
import numpy as np

def preprocess(img_path, new_shape=(48, 320)):
    img = cv2.imread(img_path)
    h, w, _ = img.shape
    resized_h = new_shape[0]
    resized_w = min(math.ceil(w / h * resized_h), new_shape[1])
    img = cv2.resize(img, (resized_w, resized_h))
    img = (img.astype('float32') - 127.5) * 0.0078125
    padding_im = np.zeros((new_shape[0], new_shape[1], 3), dtype=np.float32)
    padding_im[:, :resized_w, :] = img
    padding_im = np.expand_dims(padding_im, axis=0)
    return padding_im


def postprocess(outputs):
    outputs = int(outputs.argmax(1))
    return outputs
