# HRNet 部署示例

该示例来自 [deep-high-resolution-net.pytorch](https://github.com/leoxiaobin/deep-high-resolution-net.pytorch) 项目, 权重使用的是 [pose_hrnet_w32_256x192.pth](https://drive.google.com/file/d/1zYC7go9EV0XaSlSBjMaiyE_4TcHc_S38/view?usp=drive_link)。

整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [HRNet 部署示例](#hrnet-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#41-精度测试)
    - [4.2 性能测试](#42-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准与测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017.zip)
3. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/hrnet.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/hrnet_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/hrnet.rbo)

## 1. 模型转换

导出 onnx 模型：

```shell
$ mkdir outputs
$ git clone https://github.com/leoxiaobin/deep-high-resolution-net.pytorch
$ cd deep-high-resolution-net.pytorch
# 请按项目要求安装好上述项目，并提前下载好权重文件 (pose_hrnet_w32_256x192.pth) 到当前目录下。
$ cp ../export_onnx.py ./
```

导出 onnx 前，请先把 `deep-high-resolution-net.pytorch/lib/models/__init__.py` 中的：

```shell
import models.pose_resnet
import models.pose_hrnet
```

这两行代码注释，然后执行：

```shell
$ python export_onnx.py \
   --cfg experiments/coco/hrnet/w32_256x192_adam_lr1e-3.yaml \
   --onnx-path ../outputs/hrnet.onnx \
   TEST.MODEL_FILE pose_hrnet_w32_256x192.pth \
   TEST.USE_GT_BBOX False
```

最后我们从 onnx 导出 sg：

```shell
$ rbcc parse --onnx outputs/hrnet.onnx --sg outputs/hrnet.sg 
The version of rbcc installed is 1.2.0
2025-04-27 16:44:04 - RBCC - INFO - Start parse 'outputs/hrnet.onnx' onnx model.
2025-04-27 16:44:13 - RBCC - INFO - ONNX model parsed successfully.
2025-04-27 16:44:13 - RBCC - INFO - Model's input  0: name=input_1, shape=[1, 256, 192, 3], dtype=float32.
2025-04-27 16:44:13 - RBCC - INFO - Model's output 0: name=2901, shape=[1, 64, 48, 17], dtype=float32.
SG IR saved in outputs/hrnet.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从数据集中随机抽取 1000 个样本，作为量化校准数据集。在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载量化校准数据集。

对数据集 `COCO2017.zip` 解压，然后使用量化脚本对 sg 进行量化：

```shell
$ python quantize_sg.py outputs/hrnet.sg ./COCO2017/
Quantize Calibration - Gauss: 1000sample [00:13, 1.14sample/s]
```

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg ./outputs/hrnet_8bit.sg --rbo ./outputs/hrnet.rbo
The version of rbcc installed is 1.2.0
2025-04-27 17:38:33 - RBCC - INFO - Start loading './outputs/hrnet_8bit.sg'.
2025-04-27 17:38:33 - RBCC - INFO - Loading sg end.
2025-04-27 17:38:33 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-27 17:38:38 - RBCC - INFO - Compilation is completed, rbo has been saved to './outputs/hrnet.rbo'.
```

## 4. 模型测试

成功编译生成 rbo 后，我们需要在 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用环境安装](../rbo_exe.md)。

### 4.1 精度测试

| Model       | DataSet    |  Dtype | AP      | AP .5  |
| ----------- | ---------- | ------ | --------| ------ |
| HRNet       | COCO2017   |  fp32  | 75.6    | 93.6   |
| HRNet-sg    | COCO2017   |  uint8 | 75.3    | 93.5   |
| HRNet-rbo   | COCO2017   |  uint8 | 75.2    | 93.5   |

该模型使用 COCO2017 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── COCO2017
    ├── annotations             # 图片标签
    └── val2017                 # 测试图片, 共 5000 张
```

评估方式如下：

```shell
# scp rbo 到硬件设备上
$ scp outputs/hrnet.rbo root@192.168.12.169:/data
$ python eval_acc.py /data/hrnet.rbo --data ./COCO2017 --device-id 0
```
> 评估前，确保 hrnet.rbo 已经 scp 到 430 系列盒子上，并且容器是可以访问到的路径。

参数介绍：

- `--data`：COCO2017 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。


若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python eval_acc.py outputs/hrnet_8bit.sg --data ./COCO2017 --device-id 0 
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.2 性能测试

参考 [rbo 性能测试](../rbo_perf.md)
