# CSwin 部署示例

该示例来自 [CSWin-Transformer](https://github.com/microsoft/CSWin-Transformer) 项目，开始前，请先克隆源项目，并安装以下依赖库：

```shell
git clone https://github.com/microsoft/CSWin-Transformer.git
pip install timm==0.4.9
pip install einops
```

请提前下载好 [cswin_tiny_224.pth](https://github.com/microsoft/CSWin-Transformer/releases/download/v0.1.0/cswin_tiny_224.pth) 权重文件到 `CSWin-Transformer` 项目下。

整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR（以下简称 sg 文件），用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [CSwin 部署示例](#cswin-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#41-精度测试)
    - [4.2 性能测试](#42-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/imagenet2012_Quantization_200.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/imagenet2012_5k.zip)
3. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/cswin_tiny.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/cswin_tiny_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/cswin_tiny.rbo)

## 1. 模型转换

导出 onnx 模型：

```shell
$ mkdir outputs
$ cd CSWin-Transformer
$ cp ../export_onnx.py ./
$ python export_onnx.py ../outputs/cswin_tiny.onnx
$ cd ..
```

把 onnx 模型转换成 sg：

```shell
$ rbcc parse --onnx outputs/cswin_tiny.onnx --sg outputs/cswin_tiny.sg 
The version of rbcc installed is 1.2.0
2025-04-26 18:31:59 - RBCC - INFO - Start parse 'outputs/cswin_tiny.onnx' onnx model.
2025-04-26 18:32:25 - RBCC - INFO - ONNX model parsed successfully.
2025-04-26 18:32:25 - RBCC - INFO - Model's input  0: name=img, shape=[1, 224, 224, 3], dtype=float32.
2025-04-26 18:32:25 - RBCC - INFO - Model's output 0: name=fc2conv2d_flatten__0, shape=[-1, 1000], dtype=float32.
SG IR saved in outputs/cswin_tiny.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载量化校准数据集。

对量化校准数据集 `imagenet2012_Quantization_200.zip` 解压，然后执行：

```shell
$ python quantize_sg.py outputs/cswin_tiny.sg imagenet2012_Quantization_200
Quantize Calibration - EMA: 200sample [02:29,  1.34sample/s]
```

> cswin 模型量化时需要指定残差连接（shortcut）不量化，以保证模型量化精度损失在可接受范围内，在 SG-IR 中，残差连接是 `Eltwise` 算子，我们通过传入 `qconfig` 参数指定，具体用法请参考 rbcc 手册量化部分使用文档。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
# 为了加快模型上板运行速度，开始前需要对 cswin_tiny_8bit.sg 进行结构优化。
$ python sg_rewriter.py outputs/cswin_tiny_8bit.sg outputs/cswin_tiny_8bit_opt.sg
$ rbcc gen --sg outputs/cswin_tiny_8bit_opt.sg --custom-op-py custom_op_rbo.py --config env.json --rbo outputs/cswin_tiny.rbo
The version of rbcc installed is 1.2.0
2025-04-26 18:46:21 - RBCC - INFO - Start loading 'outputs/cswin_tiny_8bit_opt.sg'.
2025-04-26 18:46:21 - RBCC - INFO - Loading sg end.
2025-04-26 18:46:21 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-26 18:46:33 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/cswin_tiny.rbo'.
```

`--config env.json` 指定编译优化项，使用后模型性能更佳。

## 4. 模型测试

成功编译生成 rbo 后，我们需要在 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用环境安装](../rbo_exe.md)。

### 4.1 精度测试

| Model          | DataSet          | Dtype | Acc@Top-1 | Acc@Top-5 |
| -------------- | ---------------- | ----- | --------- | --------- |
| CSwin-Tiny     | ImageNet(5K)     | fp32  | 82.98     | 96.08     |
| CSwin-Tiny-sg  | ImageNet(5K)     | uint8 | 82.96     | 95.98     |
| CSwin-Tiny-rbo | ImageNet(5K)     | uint8 | 82.76     | 96.00     |

该模型使用 ImageNet 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── imagenet2012_5k
    ├── xxx.JPEG                # 测试图片, 共 5000 张
    └── val.txt                 # 图片分类标签
```

评估方式如下：

```shell
# scp rbo 到远程盒子上
$ scp outputs/cswin_tiny.rbo root@192.168.12.169:/data/
$ python ../../tools/eval_imagenet.py /data/cswin_tiny.rbo --preprocess-py preprocess.py  --data ~/datasets/imagenet2012_5k/ --device-id 0 --batch-size 1
INFO: Init Runner.
INFO: Load model from /data/cswin_tiny.rbo
INFO: connect to 192.168.12.169:50052
Model uploaded successfully. Model ID: 5d16b945e083a88c4f3b7a4e5ea2f5c2
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in ImageNet-1K: 100%|█████████████████████████████████████████████████████████████████████████| 5000/5000 [21:02<00:00,  3.96img/s]
Top1-Acc: 82.76, Top5-Acc: 96.00
```

参数介绍：

- `--preprocess-py`：前后处理脚本。
- `--data`：imagenet2012_5k 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--batch-size`：模型输入 Batch 大小。

> 前面步骤中 rbo 输入的 batch 默认为 1，故这里我们只能指定 batch 为 1。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python ../../tools/eval_imagenet.py outputs/cswin_tiny_8bit.sg --preprocess-py preprocess.py  --data ~/datasets/imagenet2012_5k/ --device-id 0 --batch-size 1
INFO: Init Runner.
INFO: Load model from outputs/cswin_tiny_8bit.sg
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in ImageNet-1K: 100%|██████████████████████████████████| 5000/5000 [22:11<00:00,  3.76img/s]
Top1-Acc: 82.96, Top5-Acc: 95.98
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.2 性能测试

参考 [rbo 性能测试](../rbo_perf.md)
