import cv2
import numpy as np

def preprocess(img_path):
    video_array = np.load(img_path)
    frames = []
    for frame in video_array:
        frame = cv2.resize(frame, (171, 128))
        frame = frame[8:120, 30:142, :] - np.array([[[104.0, 117.0, 123.0]]])
        frames.append(frame)
    frames = np.stack(frames, 0)[None, ...].astype(np.float32)
    return frames


def postprocess(outputs):
    outputs = outputs.argmax(1).tolist()[0] + 1
    return outputs
