# C3D 部署示例

该示例来自 [mmaction2](https://github.com/open-mmlab/mmaction2.git) 项目, 权重使用的是 [c3d_sports1m-pretrained_8xb30-16x1x1-45e_ucf101-rgb_20220811-31723200.pth](https://download.openmmlab.com/mmaction/v1.0/recognition/c3d/c3d_sports1m-pretrained_8xb30-16x1x1-45e_ucf101-rgb/c3d_sports1m-pretrained_8xb30-16x1x1-45e_ucf101-rgb_20220811-31723200.pth)。

整体步骤如下：

1. 把 ONNX 模型转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [C3D 部署示例](#c3d-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#41-精度测试)
    - [4.2 性能测试](#42-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了 onnx、sg 和 rbo 文件，您可快速从任一步骤开始。

1. [量化校准与测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/UCF101.zip)
2. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/c3d.onnx)
3. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/c3d_8bit.sg)
4. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/c3d.rbo)

## 1. 模型转换

导出 onnx 模型：

```shell
$ mkdir outputs
$ wget https://download.openmmlab.com/mmaction/v1.0/recognition/c3d/c3d_sports1m-pretrained_8xb30-16x1x1-45e_ucf101-rgb/c3d_sports1m-pretrained_8xb30-16x1x1-45e_ucf101-rgb_20220811-31723200.pth
$ python export_onnx.py ./c3d_sports1m-pretrained_8xb30-16x1x1-45e_ucf101-rgb_20220811-31723200.pth outputs/c3d.onnx
```

导出 sg：

```shell
$ rbcc parse --onnx outputs/c3d.onnx --sg outputs/c3d.sg 
The version of rbcc installed is 1.2.0
2025-04-28 11:52:12 - RBCC - INFO - Start parse 'outputs/c3d.onnx' onnx model.
2025-04-28 11:52:16 - RBCC - INFO - ONNX model parsed successfully.
2025-04-28 11:52:16 - RBCC - INFO - Model's input  0: name=input, shape=[1, 16, 112, 112, 3], dtype=float32.
2025-04-28 11:52:16 - RBCC - INFO - Model's output 0: name=fc2conv2d_flatten__2, shape=[-1, 101], dtype=float32.
SG IR saved in outputs/c3d.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Frame, Height, Width] 转换成 [Batch, Frame, Height, Width, Channel] 格式。

## 2. 模型量化

在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载 `UCF101.zip` 数据集，并对数据集 `UCF101.zip` 解压，量化步骤如下：

```shell
$ python quantize_sg.py outputs/c3d.sg UCF101/quantset_npy/
Quantize Calibration - Histogram: 50sample [00:03, 12.58sample/s]
```

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/c3d_8bit.sg --rbo outputs/c3d.rbo
The version of rbcc installed is 1.2.0
2025-04-28 12:05:48 - RBCC - INFO - Start loading 'outputs/c3d_8bit.sg'.
2025-04-28 12:05:48 - RBCC - INFO - Loading sg end.
2025-04-28 12:05:48 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-28 12:05:57 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/c3d.rbo'.
```

## 4. 模型测试

成功编译生成 rbo 后，我们需要在 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

### 4.1 精度测试

| Model   | DataSet          |  fp32@Acc     |  sg-int8@Acc | rbo-int8@Acc     |
| ------- | ---------------- | ------------- | ------------- | ---------------- |
| C3D     | UCF101(Part)     |  88.38        |  88.80        | 88.80            |

该模型使用 UCF101 数据集的部分测试集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── UCF101
    ├── classInd.json   # 标签 ID 
    ├── quantset_npy    # 量化数据        
    └── test_npy        # 测试数据
```

评估方式如下：

```shell
# scp rbo 到硬件设备上
$ scp outputs/c3d.rbo root@192.168.12.169:/data/
$ python eval_acc.py /data/c3d.rbo --data ./UCF101/ --device-id 0
INFO: Init Runner.
INFO: Load model from /data/c3d.rbo
INFO: connect to 192.168.12.169:50052
Model uploaded successfully. Model ID: 44f0507a056bbdf0836a93f7bef79caa
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in UCF101:  98%|█████████████████████████████████▊  | 241/245 [04:02<00:04,  1.01s/img]
INFO: Acc: 88.8
```

> 评估前，确保 c3d.rbo 已经 scp 到 430 系列盒子上，并且容器是可以访问到的路径。

参数介绍：

- `/data/c3d.rbo`：远程盒子 rbo 路径。
- `--data`: UCF101 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python eval_acc.py outputs/c3d_8bit.sg --data ./UCF101/ --device-id 0 
INFO: Init Runner.
INFO: Load model from outputs/c3d_8bit.sg
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in UCF101:  98%|████████████████████████████████████████████████▊  | 241/245 [00:03<00:00, 79.46img/s]
INFO: Acc: 88.80
```

### 4.2 性能测试

参考 [rbo 性能测试](../rbo_perf.md)

