# YOLOX 部署示例

该示例来自 [yolox](https://github.com/Megvii-BaseDetection/YOLOX.git) 项目, 权重使用的是 [yolox_s.pth](https://github.com/Megvii-BaseDetection/YOLOX/releases/download/0.1.1rc0/yolox_s.pth)。

整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [YOLOX 部署示例](#yolox-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
    - [3.1 端到端编译](#31-端到端编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017_Quantization_100.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017.zip)
3. [onnx 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/yolox_s.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/yolox_s_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/yolox_s.rbo)

## 1. 模型转换

使用 [yolox](https://github.com/Megvii-BaseDetection/YOLOX.git) 项目导出 `yolox_s.onnx` 步骤如下：

```shell
git clone https://github.com/Megvii-BaseDetection/YOLOX.git
cd YOLOX
# 请提前下载好 yolox_s.pt 权重到当前目录下 (https://github.com/Megvii-BaseDetection/YOLOX/releases/download/0.1.1rc0/yolox_s.pth) 
# 导出前需要将 tools/export_onnx.py 文件中的 `torch.onnx._export` 代码改为 `torch.onnx.export`
python tools/export_onnx.py --output-name yolox_s.onnx -n yolox-s -c yolox_s.pth --decode_in_inference
cd ..
mkdir outputs
cp YOLOX/yolox_s.onnx outputs
```

也可从[模型与数据集下载](#0-模型与数据集下载)提供的链接下载 `yolox_s.onnx`，使用 `mkdir outputs` 新建 outputs 文件夹，把 `yolox_s.onnx` 模型移动到 `outputs` 文件夹内。

从 onnx 模型导出 sg：

```shell
$ rbcc parse --onnx outputs/yolox_s.onnx --sg outputs/yolox_s.sg
The version of rbcc installed is 1.2.3
2025-10-23 15:06:00 - RBCC - INFO - Start parse 'outputs/yolox_s.onnx' onnx model.
2025-10-23 15:06:05 - RBCC - INFO - ONNX model parsed successfully.
2025-10-23 15:06:05 - RBCC - INFO - Model's input  0: name=images, shape=[1, 3, 640, 640], dtype=float32.
2025-10-23 15:06:05 - RBCC - INFO - Model's output 0: name=output, shape=[1, 8400, 85], dtype=float32.
SG IR saved in outputs/yolox_s.sg
```

为了提高模型在硬件设备上的推理性能，需要对模型结构进行优化：

```shell
python rewrite_sg.py outputs/yolox_s.sg
```

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `COCO2017_Quantization_100.zip` 到该文件夹内。

解压 `COCO2017_Quantization_100.zip` 后量化 sg：

```shell
$ python quantize_sg.py outputs/yolox_s.sg COCO2017_Quantization_100
Quantize Calibration - Histogram: 200sample [00:13, 15.13sample/s]
```

> 为了减小模型的量化损失，我们采用了 `per-channel` 量化方式。
> 该示例可用于您集成到代码环境中的参考。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/yolox_s_8bit.sg --rbo outputs/yolox_s.rbo --config env.json
The version of rbcc installed is 1.2.2
2025-10-23 16:30:18 - RBCC - INFO - Start loading 'outputs/yolox_s_8bit.sg'.
2025-10-23 16:30:18 - RBCC - INFO - Loading sg end.
2025-10-23 16:30:18 - RBCC - INFO - Start compiling the model and generate rbo.
2025-10-23 16:30:29 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/yolox_s.rbo'.
```

> `--config env.json` 指定编译优化项，使用后模型性能更佳。

### 3.1 端到端编译

通过 rbpy API，我们可以把前后处理和主干网络连接在一起编译生成端到端的 rbo，此示例用法如下：

```shell
python compile_end2end.py outputs/yolox_s_8bit.sg outputs/yolox_s_e2e.rbo --config env.json
```

此脚本把 1080p 图像作为输入，前处理和后处理都在 rbo 中。


## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
python demo.py outputs/yolox_s.rbo ../../imgs/demo.jpg
```

### 4.2 精度测试

全数据集精度测试：

| Model       | DataSet        | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | -------------- | ------ | -------------------- | ----------------- |
| YOLOX-S     | COCO2017(5k)   | fp32   | 40.4                 | 59.3              |
| YOLOX-S-sg  | COCO2017(5k)   | uint8  | 39.9                 | 58.8              |
| YOLOX-S-rbo | COCO2017(5k)   | uint8  | 39.8                 | 58.7              |

部分数据集精度测试（前 500 imgs）：

| Model       | DataSet         | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | --------------- | ------ | -------------------- | ----------------- |
| YOLOX-S     | COCO2017(500)   | fp32   | 44.1                 | 62.9              |
| YOLOX-S-sg  | COCO2017(500)   | uint8  | 43.9                 | 62.4              |
| YOLOX-S-rbo | COCO2017(500)   | uint8  | 43.7                 | 62.4              |

该模型使用 COCO2017 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── COCO2017
    ├── annotations             # 图片标签
    └── val2017                 # 测试图片, 共 5000 张
```

评估方式如下：

```shell
python ../../tools/eval_coco.py data/yolox_s.rbo --preprocess-py preprocess.py --data ./COCO2017 --yolo-coco --device-id 0
```

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
python ../../tools/eval_coco.py outputs/yolox_s_8bit.sg --preprocess-py preprocess.py --data ./COCO2017 --yolo-coco --device-id 0
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)