# YOLOv9 部署示例

该示例使用 [yolov9](https://docs.ultralytics.com/models/yolov9/) 提供的 [yolov9t](https://github.com/ultralytics/assets/releases/download/v8.3.0/yolov9t.pt) 预训练权重。

整体步骤如下：

1. 导出 onnx 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [YOLOv9 部署示例](#yolov9-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017_Quantization_100.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017.zip)
3. [onnx 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/yolov9t.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/yolov9t_8bit.sg)
5. [yolov9t rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/yolov9t.rbo)

## 1. 模型转换

使用 `ultralytics` 项目导出 `yolov10n.onnx` 步骤如下：

```shell
pip install ultralytics
```

导出 onnx：

```python
from ultralytics import YOLO

model = YOLO('yolov9t.pt', task='detect')
model_path = model.export(format="onnx", dynamic=False, simplify=True, device="cpu", nms=False)
print(f"saved on {model_path}.")
```

也可从[模型与数据集下载](#0-模型与数据集下载)提供的链接下载 `yolov9t.onnx`，

使用 `mkdir outputs` 新建 outputs 文件夹，把 `yolov9t.onnx` 模型移动到 `outputs` 文件夹内。

从 onnx 模型导出 sg：

```shell
$ rbcc parse --onnx outputs/yolov9t.onnx --sg outputs/yolov9t.sg
The version of rbcc installed is 1.2.0
2025-05-06 14:52:17 - RBCC - INFO - Start parse 'outputs/yolov9t.onnx' onnx model.
2025-05-06 14:52:20 - RBCC - INFO - ONNX model parsed successfully.
2025-05-06 14:52:20 - RBCC - INFO - Model's input  0: name=images, shape=[1, 640, 640, 3], dtype=float32.
2025-05-06 14:52:20 - RBCC - INFO - Model's output 0: name=output0, shape=[1, 84, 8400], dtype=float32.
SG IR saved in outputs/yolov9t.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

为了提高模型在硬件设备上的推理性能，可以对模型结构进行优化：

```shell
python rewriter_sg.py outputs/yolov9t.sg
```

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `COCO2017_Quantization_100.zip` 到该文件夹内。

对量化校准数据集 `COCO2017_Quantization_100.zip` 解压，然后对 sg 进行量化：

```shell
$ python quantize_sg.py outputs/yolov9t.sg COCO2017_Quantization_100
Quantize Calibration - Histogram: 100sample [00:10,  9.11sample/s]
```

> 为了减小模型的量化损失，我们采用了 `WeightReconQunatizer` 量化方法，该方法可以通过学习一组自适应的舍入参数，来优化每个权重的舍入方式。具体设置请参考 rbcc 手册量化部分。
> 该示例可用于您集成到代码环境中的参考。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/yolov9t_8bit.sg --rbo outputs/yolov9t.rbo --config env.json
The version of rbcc installed is 1.2.0
2025-04-23 17:15:59 - RBCC - INFO - Start loading 'outputs/yolov9t_8bit.sg'.
2025-04-23 17:15:59 - RBCC - INFO - Loading sg end.
2025-04-23 17:15:59 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-23 17:16:02 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/yolov9t.rbo'.
```

> `--config env.json` 指定编译优化项，使用后模型性能更佳。

## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

使用 scp 将 `yolov9t.rbo` 上传到 CAISA 430 设备可访问的路径：

```shell
scp outputs/yolov9t.rbo root@192.168.12.169:/data/yolov9t.rbo
```

### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
python demo.py /data/yolov9t.rbo ../../imgs/demo.jpg
```

### 4.2 精度测试

全数据集精度测试：

| Model       | DataSet        | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | -------------- | ------ | -------------------- | ----------------- |
| YOLOv9t     | COCO2017(5k)   |  fp32  | 38.0                 | 52.8              |
| YOLOv9t-sg  | COCO2017(5k)   |  uint8 | 37.3                 | 52.2              |
| YOLOv9t-rbo | COCO2017(5k)   |  uint8 | 37.2                 | 52.0              |

部分数据集精度测试（前 500 imgs）：

| Model       | DataSet         | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | --------------- | ------ | -------------------- | ----------------- |
| YOLOv9t     | COCO2017(500)   |  fp32  | 42.2                 | 57.6              |
| YOLOv9t-sg  | COCO2017(500)   |  uint8 | 41.3                 | 56.4              |
| YOLOv9t-rbo | COCO2017(500)   |  uint8 | 41.2                 | 56.4              |

该模型使用 COCO2017 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── COCO2017
    ├── val2017                 # 测试图片, 共 5000 张
    └── annotations             # 标签
```

评估方式如下：

```shell
python ../../tools/eval_coco.py \
      /data/yolov9t.rbo \
      --preprocess-py preprocess.py \
      --data ~/datasets/COCO2017 \
      --device-id 0  \
      --yolo-coco
```

参数介绍：

- `--preprocess-py`：预处理和后处理脚本路径。
- `--data`：COCO2017 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定为 -1。
- `--yolo-coco`：表示使用 80 个类别的精度评价。
- `--eval-nums`：评估的样本数量，COCO2017 验证数据集共有 5000 张图片。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
python ../../tools/eval_coco.py \
    outputs/yolov9t_8bit.sg \
    --preprocess-py preprocess.py \
    --data ~/datasets/COCO2017 \
    --device-id 0  \
    --yolo-coco
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)