# PP-YOLOE 部署示例

该模型来自 [PaddleDetection](https://github.com/PaddlePaddle/PaddleDetection), 这里使用的使用 [ppyoloe_crn_s_80e_smoking_visdrone.zip](https://bj.bcebos.com/v1/paddledet/models/pipeline/ppyoloe_crn_s_80e_smoking_visdrone.zip) 权重。

整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 把 onnx 转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
3. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
4. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
5. 对 rbo 进行性能测试和精度测试。

**目录**

- [PP-YOLOE 部署示例](#pp-yoloe-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/smoking-quantset.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/smoking-testset.zip)
3. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/pp_yoloe.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/pp_yoloe_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/pp_yoloe.rbo)

## 1. 模型转换

导出 onnx 模型：

```shell
# 开始前请先提前下载好模型权重：https://bj.bcebos.com/v1/paddledet/models/pipeline/ppyoloe_crn_s_80e_smoking_visdrone.zip 并解压到当前目录下。
$ pip install onnx-simplifier==0.4.10
$ pip install paddlepaddle==2.6.2 paddle2onnx==1.3.1
$ mkdir outputs
$ paddle2onnx --model_dir ./ppyoloe_crn_s_80e_smoking_visdrone \
    --model_filename model.pdmodel \
    --params_filename model.pdiparams \
    --save_file outputs/pp_yoloe.onnx \
    --opset_version 11 \
    --enable_onnx_checker True
$ onnxsim outputs/pp_yoloe.onnx outputs/pp_yoloe.onnx --input-shape image:1,3,640,640 scale_factor:1,2
```

从 onnx 模型导出 sg：

```shell
$ rbcc parse --onnx outputs/pp_yoloe.onnx --sg outputs/pp_yoloe.sg
The version of rbcc installed is 1.2.3
2025-11-04 16:10:48 - RBCC - INFO - Start parse 'outputs/pp_yoloe.onnx' onnx model.
2025-11-04 16:10:54 - RBCC - INFO - ONNX model parsed successfully.
2025-11-04 16:10:54 - RBCC - INFO - Model's input  0: name=image, shape=[1, 640, 640, 3], dtype=float32.
2025-11-04 16:10:54 - RBCC - INFO - Model's input  1: name=scale_factor, shape=[1, 2], dtype=float32.
2025-11-04 16:10:54 - RBCC - INFO - Model's output 0: name=multiclass_nms3_0_tmp_0, shape=[-1, 6], dtype=float32.
2025-11-04 16:10:54 - RBCC - INFO - Model's output 1: name=multiclass_nms3_0_tmp_2, shape=[1], dtype=int32.
SG IR saved in outputs/pp_yoloe.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 个样本，作为量化校准数据集。在进行量化前请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `smoking-quantset.zip` 到该文件夹内。

对量化校准数据集 COCO2017_Quantization_100.zip 解压，然后执行：

```shell
$ python quantize_sg.py outputs/pp_yoloe.sg smoking-quantset
Quantize Calibration - Histogram: 100%|█████████████████████████████████████████████████████████████████████████████████████████████████████████| 100/100 [00:31<00:00,  3.18sample/s]
```

> 该示例可用于您集成到代码环境中的参考。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/pp_yoloe_8bit.sg --rbo outputs/pp_yoloe.rbo --inputs image:1x640x640x3,scale_factor:1x2 --outputs multiclass_nms3_0_tmp_0:300x6,multiclass_nms3_0_tmp_2:1 --config env.json

The version of rbcc installed is 1.2.2
2025-11-10 14:22:54 - RBCC - INFO - Start loading 'outputs/pp_yoloe_8bit.sg'.
2025-11-10 14:22:54 - RBCC - INFO - Loading sg end.
2025-11-10 14:22:54 - RBCC - INFO - Change the shape of input 'image' to [1, 640, 640, 3].
2025-11-10 14:22:54 - RBCC - INFO - Change the shape of input 'scale_factor' to [1, 2].
2025-11-10 14:22:54 - RBCC - INFO - Change the shape of output 'multiclass_nms3_0_tmp_0' to [300, 6].
2025-11-10 14:22:54 - RBCC - INFO - Change the shape of output 'multiclass_nms3_0_tmp_2' to [1].
2025-11-10 14:22:54 - RBCC - INFO - Start compiling the model and generate rbo.
2025-11-10 14:23:43 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/pp_yoloe.rbo'.
```

`--inputs image:1x640x640x3,scale_factor:1x2 ` 指定输入顺序与输入大小。
`--outputs multiclass_nms3_0_tmp_0:300x6,multiclass_nms3_0_tmp_2:1 ` 固定输出大小。
`--config env.json` 指定编译优化项，使用后模型性能更佳。

## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。


### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
python demo.py outputs/pp_yoloe.rbo ../../imgs/caller_smoker.jpg
```

### 4.2 精度测试

全数据集精度测试：

| Model       | DataSet                | dtype  | Acc     | 
| ----------- | ---------------------- | ------ | ------- |
| PP-YOLOE    | smoking-testset(400)   |  fp32  |  82.0   |
| PP-YOLOE    | smoking-testset(400)   |  uint8 |  81.75  |
| PP-YOLOE    | smoking-testset(400)   |  uint8 |  81.75  |

该模型使用 smoking-testset 数据集进行精度评估，数据集来自 [smoking and not-smoking images](https://aistudio.baidu.com/datasetdetail/198887)，
下载解压后从 `validation_data` 中选择了所有数据作为测试集（共计 400 张），从 `training_data` 中选择 100 张作为量化数据。
请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，解压后文件结构如下：

```shell
└── smoking-testset
    ├── smokers_0.jpg  # 吸烟图片
    ...
    └── others_0.jpg   # 没吸烟图片             
```

评估方式如下：

```shell
python eval_acc.py outputs/pp_yoloe.rbo --data ./smoking-testset
INFO: Init Runner.
INFO: Load model from outputs/pp_yoloe.rbo
Model Uploading: 100%|█████████████████████████████████████████████████████████████████| 10.1M/10.1M [00:00<00:00, 15.6MB/s]
[2025-11-18 11:16:23.094] [ INFO ] [Client] Model loading successful from loacl path - Model ID: afa15125-94b1-4cf3-a843-48d198e378fa
INFO: Load dataset.
INFO: Start inference.
Eval in Smoking-Data: 100%|████████████████████████████████████████████████████████████| 400/400 [02:40<00:00,  2.49img/s]
Model remove successfully. Model ID: afa15125-94b1-4cf3-a843-48d198e378fa
INFO: Acc: 81.75
```

参数介绍：

- `--data`：数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--eval-nums`：指定数据集的大小。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
python eval_acc.py outputs/pp_yoloe_8bit.sg --data smoking-testset/
INFO: Init Runner.
INFO: Load model from outputs/pp_yoloe_8bit.sg
INFO: Load dataset.
INFO: Start inference.
Eval in Smoking-Data: 100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 400/400 [02:17<00:00,  2.92img/s]
INFO: Acc: 81.75
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)