import cv2
import numpy as np


def preprocess(img_path):
    img = cv2.imread(img_path)
    img = img[:, :, ::-1]
    img = cv2.resize(img, (224, 224))
    mean=np.array([0.485, 0.456, 0.406], dtype=np.float32)
    std=np.array([0.229, 0.224, 0.225], dtype=np.float32)
    img = (img / 255. - mean) / std
    img = img[None, ...].astype(np.float32)
    return img
    

def postprocess(outputs):
    # outputs: [N, 2]   {0: 'Calling'  1: 'Other'}
    outputs = outputs.argmax(1).tolist()[0]
    return outputs

    