# PP-HGNet 部署示例

该模型来自 [PaddleDetection](https://github.com/PaddlePaddle/PaddleDetection), 这里使用的使用 [PPHGNet_tiny_calling_halfbody.zip](https://bj.bcebos.com/v1/paddledet/models/pipeline/PPHGNet_tiny_calling_halfbody.zip) 权重。

整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [PP-HGNet 部署示例](#pp-hgnet-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/calling-quantset.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/calling-testset.zip)
3. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/pp_hgnet.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/pp_hgnet_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/pp_hgnet.rbo)

## 1. 模型转换

导出 onnx 模型：

```shell
# 开始前请先提前下载好模型权重：https://bj.bcebos.com/v1/paddledet/models/pipeline/PPHGNet_tiny_calling_halfbody.zip 并解压到当前目录下。
$ pip install paddlepaddle==2.6.2 paddle2onnx==1.3.1
$ mkdir outputs
$ paddle2onnx --model_dir ./PPHGNet_tiny_calling_halfbody \
    --model_filename model.pdmodel \
    --params_filename model.pdiparams \
    --save_file outputs/pp_hgnet.onnx \
    --opset_version 11 \
    --enable_onnx_checker True
$ onnxsim outputs/pp_hgnet.onnx outputs/pp_hgnet.onnx --overwrite-input-shape 1,3,224,224
```

从 onnx 模型导出 sg：

```shell
$ rbcc parse --onnx outputs/pp_hgnet.onnx --sg outputs/pp_hgnet.sg
The version of rbcc installed is 1.2.2
2025-11-10 12:30:29 - RBCC - INFO - Start parse 'outputs/pp_hgnet.onnx' onnx model.
2025-11-10 12:30:32 - RBCC - INFO - ONNX model parsed successfully.
2025-11-10 12:30:32 - RBCC - INFO - Model's input  0: name=x, shape=[1, 224, 224, 3], dtype=float32.
2025-11-10 12:30:32 - RBCC - INFO - Model's output 0: name=softmax_1_tmp_0, shape=[1, 2], dtype=float32.
SG IR saved in outputs/pp_hgnet.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载量化校准数据集。

对量化校准数据集 `calling-quantset.zip` 解压，然后执行：

```shell
$ python quantize_sg.py outputs/pp_hgnet.sg calling-quantset/
Quantize Calibration - MinMax: 100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████| 100/100 [00:04<00:00, 23.38sample/s]
```

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/pp_hgnet_8bit.sg --rbo outputs/pp_hgnet.rbo
The version of rbcc installed is 1.2.2
2025-11-10 12:32:01 - RBCC - INFO - Start loading 'outputs/pp_hgnet_8bit.sg'.
2025-11-10 12:32:01 - RBCC - INFO - Loading sg end.
2025-11-10 12:32:01 - RBCC - INFO - Start compiling the model and generate rbo.
2025-11-10 12:32:26 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/pp_hgnet.rbo'.
```

## 4. 模型测试

以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用环境安装](../rbo_exe.md)。

### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
python demo.py outputs/pp_hgnet.rbo ../../imgs/caller_smoker.jpg
```

### 4.2 精度测试

Calling-Testset 数据集测试结果如下：

| Model           | DataSet               |  Dtype   | Acc        |
| --------------- | -------------------   | -------- | ---------- |
| pp_hgnet        | calling-testset(500)  |  fp32    | 69.2       |
| pp_hgnet-sg     | calling-testset(500)  |  uint8   | 68.8       |
| pp_hgnet-rbo    | calling-testset(500)  |  uint8   | 68.8       |

该模型使用 calling-testset 数据集进行精度评估，该数据集来自 [打电话分类](https://aistudio.baidu.com/datasetdetail/180629)，下载解压后从 `phone` 和 `nophone` 中分别选择 250 张作为测试集（共计 500张），另外还分别选择不同的 50 张 作为量化集（共计 100 张）。
请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，解压后文件结构如下：

```shell
└── calling-testset
    ├── callers_0.jpg  # 打电话图片
    ...
    └── others_0.jpg   # 没打电话图片             
```

评估方式如下：

```shell
$ python eval_acc.py outputs/pp_hgnet.rbo --data ./calling-testset
INFO: Init Runner.
INFO: Load model from outputs/pp_hgnet.rbo
Model Uploading: 100%|██████████████████████████████████████████████████████████████████████████| 10.1M/10.1M [00:00<00:00, 15.6MB/s]
[2025-11-18 11:16:23.094] [ INFO ] [Client] Model loading successful from loacl path - Model ID: 1506cdf0-dded-4879-a703-05ce76b06888
INFO: Load dataset.
INFO: Start inference.
Eval in Calling-Data: 100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 500/500 [00:27<00:00, 18.23img/s]
INFO: Acc 68.8
[2025-11-18 11:26:52.785] [ INFO ] [Client] Model removed successfully. Model ID: 1506cdf0-dded-4879-a703-05ce76b06888
```

参数介绍：

- `--data`: 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--eval-nums`：参与测试的样本数量。

> 前面步骤中 rbo 输入的 batch 默认为 1，故这里我们只能指定 batch 为 1。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python eval_acc.py outputs/pp_hgnet.sg --data ./calling-testset/
INFO: Init Runner.
INFO: Load model from outputs/pp_hgnet.sg
INFO: Load dataset.
INFO: Start inference.
Eval in Calling-Data: 100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 500/500 [00:10<00:00, 45.96img/s]
INFO: Acc 69.2
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)。
