# ARCFace 部署示例

该示例参考 [insightface](https://github.com/deepinsight/insightface) 项目，预训练权重使用的是 [buffalo_l.zip](https://github.com/deepinsight/insightface/releases/download/v0.7/buffalo_l.zip) 里面的 `w600k_r50.onnx` 权重。

整体步骤如下：

1. 从参考链接（`https://github.com/deepinsight/insightface/releases/download/v0.7/buffalo_l.zip`）下载  `w600k_r50.onnx` onnx 文件，也可以使用我们已经提供的 onnx 文件。
2. 把 onnx 模型转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
3. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
4. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
5. 对 rbo 进行性能测试和精度测试。

**目录**

- [ARCFace 部署示例](#arcface 部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#42-精度测试)
    - [4.2 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/megaface-quantset.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/megaface.zip)
3. [onnx 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/arcface.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/arcface_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/arcface.rbo)

## 1. 模型转换

RBCC 支持 ONNX 模型格式作为输入导出 sg，可以从[模型与数据集下载](#0-模型与数据集下载)提供的链接下载 `arcface.onnx` 至 `outputs` 文件夹内（需要新建该文件夹）。根据 onnx 解析 sg 的流程如下：

```shell
$ onnxsim outputs/w600k_r50.onnx outputs/arcface.onnx --overwrite-input-shape 1,3,112,112
$ rbcc parse --onnx outputs/arcface.onnx --sg outputs/arcface.sg
The version of rbcc installed is 1.2.2
2025-10-19 20:22:21 - RBCC - INFO - Start parse 'outputs/arcface.onnx' onnx model.
2025-10-19 20:22:28 - RBCC - INFO - ONNX model parsed successfully.
2025-10-19 20:22:28 - RBCC - INFO - Model's input  0: name=input_1, shape=[1, 112, 112, 3], dtype=float32.
2025-10-19 20:22:28 - RBCC - INFO - Model's output 0: name=fc2conv2d_flatten__0, shape=[-1, 512], dtype=float32.
SG IR saved in outputs/arcface.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从 Megaface 训练数据集中随机抽取 50 个样本，作为量化校准数据集。在进行量化前，请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `megaface-quantset.zip` 到该文件夹内。

对量化校准数据集 `megaface-quantset.zip` 解压，然后使用如下脚本进行量化：

```shell
$ python quantize_sg.py outputs/arcface.sg megaface-quantset
Quantize Calibration - Histogram: 100%  50/50 [00:10<00:00,  4.89sample/s]
```

> 该示例可用于您集成到代码环境中的参考。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/arcface_8bit.sg --rbo outputs/arcface.rbo
The version of rbcc installed is 1.2.2
2025-10-19 20:34:08 - RBCC - INFO - Start loading 'outputs/arcface_8bit.sg'.
2025-10-19 20:34:08 - RBCC - INFO - Loading sg end.
2025-10-19 20:34:08 - RBCC - INFO - Start compiling the model and generate rbo.
2025-10-19 20:34:35 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/arcface.rbo'.
```

> 该模型不支持编译时修改输入 shape，若有需求，请在导出 onnx 文件时修改输入 shape。

## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

### 4.1 精度测试

全数据集精度测试：

| Model       | DataSet        | dtype  | Acc@Top1 |
| ----------- | -------------- | ------ | -------- |
| ARCFace     | MegaFace       | fp32   | 98.75    |
| ARCFace-sg  | MegaFace       | uint8  | 98.75    |
| ARCFace-rbo | MegaFace       | uint8  | 98.75    |      

该模型使用 MegaFace 验证集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集.

评估方式如下：

```shell
$ python eval_acc.py outputs/arcface.rbo --data ./megaface --device-id 0
```

参数介绍：

- `--data`：Wider-Face 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--eval-nums`：指定数据集的大小。
- `--topk`：人脸比对范围。


若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python eval_acc.py outputs/arcface_8bit.sg --data ./megaface --device-id 0
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)