# ModelZoo 介绍

**目录**

- [ModelZoo 介绍](#modelzoo-介绍)
  - [简介](#简介)
  - [已支持模型部署示例](#已支持模型部署示例)
  - [RBBC 环境准备](#rbbc-环境准备)
  - [更新日志](#更新日志)

## 简介

RBModelZoo 提供了深度学习领域中常见的模型部署示例，每个模型部署示例都提供了基于 RainBuilder Compiler Collection(以下用 RBCC 缩写代替) 进行模型转换、量化、编译的步骤示例，供您参考和使用。

## 已支持模型部署示例

| Model                            | Type        | Source       |
| -------------------------------- | ----------- | ------------ |
| [Arcface](./models/arcface/README.md)  | Classfier         | ONNX |
| [BERT](./models/bert/README.md)  | NLP         | ONNX |
| [C3D](./models/c3d/README.md)    | 3D Classfier  | ONNX       |
| [CLIP](./models/clip/README.md)  | Classfier  | ONNX          |
| [CSwin](./models/cswin/README.md)| Classfier  | ONNX  |
| [DeiT](./models/deit/README.md)  | Classfier  | ONNX  |
| [Densenet](./models/densenet/README.md)  | Classfier  | ONNX  |
| [HRNet](./models/hrnet/README.md)  | Pose Seg  | ONNX  |
| [Inception](./models/inception/README.md)  | Classfier | ONNX  |
| [Mobilenet](./models/mobilenet/README.md)  | Classfier | ONNX  |
| [OpenPose](./models/openpose/README.md)  | Pose | ONNX  |
| [PP_HGnet](./models/pp_hgnet/README.md)  | Classfier | ONNX  |
| [PP_YOLOE](./models/pp_yoloe/README.md)  | Detection | ONNX  |
| [PPOCR-CLS](./models/ppocr_cls/README.md)  | OCR | ONNX |
| [PPOCR-DET](./models/ppocr_det/README.md)  | OCR | ONNX |
| [PPOCR-REC](./models/ppocr_rec/README.md)  | OCR | ONNX |
| [Resnet](./models/resnet/README.md)        | Classfier | ONNX  |
| [SENet](./models/senet/README.md)          | Classfier | Caffe  |
| [SqueezeNet](./models/squeezenet/README.md)| Classfier | ONNX  |
| [Swin Transformer](./models/swin/README.md)| Classfier | ONNX  |
| [Unet](./models/unet/README.md)| Segmentation | ONNX  |
| [ViT](./models/vit/README.md)| Classfier | ONNX  |
| [YOLO-World](./models/yolo_world/README.md)| Detection | ONNX |
| [YOLOv2](./models/yolov2/README.md)| Detection | ONNX |
| [YOLOv3](./models/yolov3/README.md)| Detection | ONNX |
| [YOLOv5](./models/yolov5/README.md)| Detection | ONNX |
| [YOLOv6](./models/yolov6/README.md)| Detection | ONNX |
| [YOLOv7](./models/yolov7/README.md)| Detection | ONNX |
| [YOLOv7-face](./models/yolov7-face/README.md)| Detection | ONNX |
| [YOLOv8](./models/yolov8/README.md)| Detection | ONNX |
| [YOLOv8-obb](./models/yolov8-obb/README.md)| Rotated Detection | ONNX |
| [YOLOv8-pose](./models/yolov8-pose/README.md)| Pose | ONNX |
| [YOLOv8-seg](./models/yolov8-seg/README.md)| Segmentation | ONNX |
| [YOLOv9](./models/yolov9/README.md)| Detection | ONNX |
| [YOLOv10](./models/yolov10/README.md)| Detection | ONNX |
| [YOLOv11](./models/yolov11/README.md)| Detection | ONNX |
| [YOLOv12](./models/yolov12/README.md)| Detection | ONNX |
| [YOLOx](./models/yolox/README.md)| Detection | ONNX |

## RBBC 环境准备

RBModelZoo 使用前需要安装 RBCC 环境，我们提供了 Docker 镜像，您只需下载镜像启动容器即可快速开始，具体请阅读 [RBCC 环境搭建](https://document.corerain.com/zh/3-%E7%AE%97%E6%B3%95%E7%A7%BB%E6%A4%8D/1-rbcc-docs/0-README)。

## 更新日志

- 20251130 发布 v2.2.0，新增 9 个模型，分别是 arcface、pp_hgnet、pp_yoloe、unet、yolov2\3、yolov7-face、yolov8-obb\seg\pose、yolox。
- 20251030 发布 v2.1.0，无新增模型，适配编译工具链改动。
- 20250702 发布 v2.0.0，无新增模型，主要修改了量化配置以提升模型量化精度和适配最新版本编译器，修复一些 bug 和提升 yolo 系列模型速度。
- 20250507 发布 v1.0.0。
