# YOLOv8 部署示例

该示例使用 [yolov8](https://docs.ultralytics.com/models/yolov8/) 提供的 [yolov8n](https://github.com/ultralytics/assets/releases/download/v8.3.0/yolov8n.pt) 预训练权重。

整体步骤如下：

1. 参考 [yolov8n](https://docs.ultralytics.com/models/yolov8/) 导出 onnx 文件，也可以使用我们已经导出的 onnx 文件。
2. 把 onnx 转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
3. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
4. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
5. 对 rbo 进行性能测试和精度测试。

**目录**

- [YOLOv8 部署示例](#yolov8-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
    - [3.1 端到端编译](#31-端到端编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017_Quantization_100.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017.zip)
3. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/yolov8n.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/yolov8n_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/yolov8n.rbo)

## 1. 模型转换

RBCC 支持 ONNX 模型格式作为输入导出 sg，可以从[模型与数据集下载](#0-模型与数据集下载)提供的链接下载 `yolov8n.onnx` 至该文件夹内，也可以选择自行导出 onnx 模型，onnx 模型导出方法如下：

```python
from ultralytics import YOLO

model = YOLO('yolov8n.pt', task='detect')
model_path = model.export(format="onnx", dynamic=False, simplify=True, device="cpu", nms=False)
print(f"saved on {model_path}.")
```

从 onnx 模型导出 sg：

```shell
$ mkdir outputs
$ rbcc parse --onnx yolov8n.onnx --sg outputs/yolov8n.sg 
The version of rbcc installed is 1.2.0
2025-05-06 14:51:46 - RBCC - INFO - Start parse 'yolov8n.onnx' onnx model.
/opt/miniconda/envs/rbcc/lib/python3.10/site-packages/click/decorators.py:33: UserWarning: Node '/model_10/Resize' stores empty string input for placeholder.
  return f(get_current_context(), *args, **kwargs)
/opt/miniconda/envs/rbcc/lib/python3.10/site-packages/click/decorators.py:33: UserWarning: Node '/model_13/Resize' stores empty string input for placeholder.
  return f(get_current_context(), *args, **kwargs)
2025-05-06 14:51:48 - RBCC - INFO - ONNX model parsed successfully.
2025-05-06 14:51:48 - RBCC - INFO - Model's input  0: name=images, shape=[1, 640, 640, 3], dtype=float32.
2025-05-06 14:51:48 - RBCC - INFO - Model's output 0: name=output0, shape=[1, 84, 8400], dtype=float32.
SG IR saved in outputs/yolov8n.sg

```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

为了提高模型在硬件设备上的推理性能，可以对模型结构进行优化：

```shell
python rewriter_sg.py outputs/yolov8n.sg
```

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `COCO2017_Quantization_100.zip` 到该文件夹内。

对量化校准数据集 COCO2017_Quantization_100.zip 解压，然后执行：

```shell
$ python quantize_sg.py outputs/yolov8n.sg COCO2017_Quantization_100
Quantize Calibration - Histogram: 100sample [00:04, 20.10sample/s]
```

> 为了减小模型的量化损失，我们采用了 `WeightReconQunatizer` 量化方法，该方法可以通过学习一组自适应的舍入参数，来优化每个权重的舍入方式。具体设置请参考 rbcc 手册量化部分。
> 该示例可用于您集成到代码环境中的参考。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/yolov8n_8bit.sg --rbo outputs/yolov8n.rbo --config env.json
The version of rbcc installed is 1.2.0
2025-05-06 14:55:19 - RBCC - INFO - Start loading 'outputs/yolov8n_8bit.sg'.
2025-05-06 14:55:19 - RBCC - INFO - Loading sg end.
2025-05-06 14:55:19 - RBCC - INFO - Start compiling the model and generate rbo.
2025-05-06 14:55:20 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/yolov8n.rbo'.
```

> `--config env.json` 指定编译优化项，使用后模型性能更佳。该模型不支持编译时修改输入 shape，若有需求，请在导出 onnx 文件时修改输入 shape。

### 3.1 端到端编译

通过 rbpy API，我们可以把前后处理和主干网络连接在一起编译生成端到端的 rbo，此示例用法如下：

```shell
python compile_end2end.py outputs/yolov8n_8bit.sg outputs/yolov8n_e2e.rbo --config env.json
```

此脚本把 1080p 图像作为输入，前处理和后处理都在 rbo 中。


## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

使用 scp 将 `yolov8n.rbo` 上传到 CAISA 430 设备可访问的路径：

```shell
scp outputs/yolov8n.rbo root@192.168.12.169:/data/yolov8n.rbo
```

### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
python demo.py /data/yolov8n.rbo ../../imgs/demo.jpg
```

若想测试端到端流程的 rbo，执行如下命令：

```shell
python demo.py /data/yolov8n_e2e.rbo ../../imgs/demo.jpg --e2e
```

### 4.2 精度测试

全数据集精度测试：

| Model       | DataSet        | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | -------------- | ------ | -------------------- | ----------------- |
| YOLOv8n     | COCO2017(5k)   |  fp32  |  37.3                | 52.7              |
| YOLOv8n-sg  | COCO2017(5k)   |  uint8 |  36.6                | 52.0              |
| YOLOv8n-rbo | COCO2017(5k)   |  uint8 |  36.5                | 52.0              |

部分数据集精度测试（前 500 imgs）：

| Model       | DataSet         | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | --------------- | ------ | -------------------- | ----------------- |
| YOLOv8n     | COCO2017(500)   |  fp32  | 41.8                 | 57.4              |
| YOLOv8n-sg  | COCO2017(500)   |  uint8 | 41.3                 | 56.7              |
| YOLOv8n-rbo | COCO2017(500)   |  uint8 | 40.9                 | 56.4              |

该模型使用 COCO2017 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── COCO2017
    ├── val2017                 # 测试图片, 共 5000 张
    └── annotations             # 标签
```

评估方式如下：

```shell
python ../../tools/eval_coco.py \
      /data/yolov8n.rbo \
      --preprocess-py preprocess.py \
      --data ~/datasets/COCO2017 \
      --device-id 0  \
      --yolo-coco \
      --eval-nums 5000 \
      --conf 0.001
```

参数介绍：

- `--preprocess-py`：前后处理脚本。
- `--data`：COCO2017 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--yolo-coco`：表示使用 80 个类别的精度评价。
- `--eval-nums`：指定数据集的大小，COCO2017 验证数据集共用 5000 张图片。
- `--conf`：nms 分数阈值参数。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
python ../../tools/eval_coco.py outputs/yolov8n_8bit.sg \
      --preprocess-py preprocess.py \
      --data ~/datasets/COCO2017 \
      --device-id 0  \
      --yolo-coco \
      --eval-nums 5000 \
      --conf 0.001
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)