# YOLOv7-Face 部署示例

该示例使用 [yolov7-face](https://github.com/derronqi/yolov7-face) 提供的 [`yolov7-face`](https://drive.google.com/file/d/1oIaGXFd4goyBvB1mYDK24GLof53H9ZYo/view) 预训练权重。

整体步骤如下：

1. 参考 [yolov7-face](https://github.com/derronqi/yolov7-face) 导出 YOLOv7-Face onnx 文件，也可以使用我们已经导出的 onnx 文件。
2. 把 onnx 模型转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
3. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
4. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
5. 对 rbo 进行性能测试和精度测试。

**目录**

- [YOLOv7-Face 部署示例](#yolov7-face 部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/widerface-quantset.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/widerface-val.zip)
3. [onnx 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/yolov7-face.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/yolov7-face_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/yolov7-face.rbo)

## 1. 模型转换

RBCC 支持 ONNX 模型格式作为输入导出 sg，可以从[模型与数据集下载](#0-模型与数据集下载)提供的链接下载 `yolov7-face.onnx` 至 `outputs` 文件夹内（需要新建该文件夹），也可以选择自行导出 onnx 模型，导出 onnx 的流程如下：

```shell
$ git clone https://github.com/derronqi/yolov7-face.git
$ cd yolov7-face
$ pip install -r requirements.txt
# 请提前下载好 yolov7-face.pt（https://drive.google.com/file/d/1oIaGXFd4goyBvB1mYDK24GLof53H9ZYo/view）权重文件到 yolov7-face 目录下.
# 为了加快模型的推理速度，需要将源项目中的 'models/yolo.py' 进行替换
$ cp ../yolo.py models/
$ python models/export.py --weights yolov7-face.pt --simplify --grid
$ cd ..
$ mkdir outputs
$ cp yolov7-face/yolov7-face.onnx outputs/
```

> 注： 如果在导出 onnx 时出现如下报错：`_pickle.UnpicklingError: Weights only load failed`，可以将 `yolov7-face/models/experimental.py` 脚本中的 `ckpt = torch.load(w, map_location=map_location)` 代码改为：`ckpt = torch.load(w, map_location=map_location, weights_only=False)`。

根据 onnx 解析 sg 的流程如下：

```shell
$ rbcc parse --onnx outputs/yolov7-face.onnx --sg outputs/yolov7-face.sg
The version of rbcc installed is 1.2.2
2025-09-25 17:35:29 - RBCC - INFO - Start parse 'outputs/yolov7-face.onnx' onnx model.
2025-09-25 17:35:37 - RBCC - INFO - ONNX model parsed successfully.
2025-09-25 17:35:37 - RBCC - INFO - Model's input  0: name=images, shape=[1, 640, 640, 3], dtype=float32.
2025-09-25 17:35:37 - RBCC - INFO - Model's output 0: name=1496, shape=[1, 25200, 21], dtype=float32.
2025-09-25 17:35:37 - RBCC - INFO - Model's output 1: name=onnx__Slice_527, shape=[1, 3, 80, 80, 21], dtype=float32.
2025-09-25 17:35:37 - RBCC - INFO - Model's output 2: name=onnx__Slice_859, shape=[1, 3, 40, 40, 21], dtype=float32.
2025-09-25 17:35:37 - RBCC - INFO - Model's output 3: name=onnx__Slice_1187, shape=[1, 3, 20, 20, 21], dtype=float32.
SG IR saved in outputs/yolov7-face.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从 WIDER-Face 训练数据集中随机抽取 200 个样本，作为量化校准数据集。在进行量化前，请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `widerface-quantset.zip` 到该文件夹内。

对量化校准数据集 `widerface-quantset.zip` 解压，然后使用如下脚本进行量化：

```shell
$ python quantize_sg.py outputs/yolov7-face.sg widerface-quantset
Quantize Calibration - Histogram: 100%  50/50 [00:10<00:00,  4.89sample/s]
```

> 该示例可用于您集成到代码环境中的参考。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/yolov7-face_8bit.sg --rbo outputs/yolov7-face.rbo --config env.json
The version of rbcc installed is 1.2.0
2025-04-16 12:07:57 - RBCC - INFO - Start loading 'outputs/yolov7-face_8bit.sg'.
2025-04-16 12:07:57 - RBCC - INFO - Loading sg end.
2025-04-16 12:07:57 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-16 12:08:14 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/yolov7-face.rbo'.
```

> `--config env.json` 目前仅适用于 yolov7-face 模型，在 yolov7s-face 模型中可能会导致 rbo 精度异常。
> 该模型不支持编译时修改输入 shape，若有需求，请在导出 onnx 文件时修改输入 shape。

### 3.1 端到端编译

通过 rbpy API，我们可以把前后处理和主干网络连接在一起编译生成端到端的 rbo，此示例用法如下：

```shell
python compile_end2end.py outputs/yolov7-face_8bit.sg outputs/yolov7-face_e2e.rbo --config env.json
```

> `--config env.json` 目前仅适用于 yolov7-face 模型，在 yolov7s-face 模型中可能会导致 rbo 精度异常。

此脚本把 1080p 图像作为输入，前处理和后处理都在 rbo 中。

## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
python demo.py /data/yolov7-face.rbo ../../imgs/person.jpg
```

若想测试端到端流程的 rbo，执行如下命令：

```shell
python demo.py /data/yolov7-face_e2e.rbo ../../imgs/person.jpg --e2e
```

### 4.2 精度测试

全数据集精度测试：

| Model           | DataSet        | dtype  | AP@Easy  | AP@Medium | AP@Hard   |
| -----------     | -------------- | ------ | -------- | -------   | -------   |
| YOLOv7-face     | Wider-Face     | fp32   | 96.88    | 95.55     | 88.18     |
| YOLOv7-face-sg  | Wider-Face     | uint8  | 96.94    | 95.60     | 88.05     |
| YOLOv7-face-rbo | Wider-Face     | uint8  | 96.92    | 95.60     | 88.06     |

该模型使用 Wider-Face 验证集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── widerface-val
    ├── images                 # 测试图片
    └── ground_truth           # 标签
```

评估方式如下：

```shell
$ python eval_acc.py outputs/yolov7-face.rbo --data ./widerface-val --device-id 0
```

参数介绍：

- `--data`：Wider-Face 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--eval-nums`：指定数据集的大小。
- `--conf`：nms 分数阈值参数。


若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python eval_acc.py outputs/yolov7-face_8bit.sg --data ./widerface-val --device-id 0
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)