# Yolov6 部署示例

该示例来自 [YOLOv6](https://github.com/meituan/YOLOv6) 项目, pt 权重使用的是 [yolov6n.pt](https://github.com/meituan/YOLOv6/releases/download/0.4.0/yolov6n.pt)。

整体步骤如下：

1. 把 ONNX 模型转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

## 目录

- [Yolov6 部署示例](#yolov6-部署示例)
  - [目录](#目录)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
    - [1.1 模型优化](#11-模型优化)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg, onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017_Quantization_100.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017.zip)
3. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/yolov6n.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/yolov6n_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/yolov6n.rbo)

## 1. 模型转换

RBCC 支持 ONNX 模型格式作为输入导出 sg，可以从[模型与数据集下载](#0-模型与数据集下载)提供的链接下载 `yolov6n.onnx` 至 `outputs` 文件夹内（需要新建该文件夹），也可以选择自行导出 onnx 模型，导出 onnx 的流程如下：

```shell
$ git clone https://github.com/meituan/YOLOv6.git
$ cd YOLOv6
$ pip install -r requirements.txt
# 请提前下载好 yolov6n.pt（https://github.com/meituan/YOLOv6/releases/download/0.4.0/yolov6n.pt）权重文件到 YOLOv6 目录下.
$ python ./deploy/ONNX/export_onnx.py --weights ./yolov6n.pt --img 640 --batch 1 --simplify
$ mkdir outputs
$ cp yolov6n.onnx ../outputs/
$ cd ..
```

> 注： 如果在导出 onnx 时出现如下报错：`_pickle.UnpicklingError: Weights only load failed`，可以将 `yolov6/utils/checkpoint.py` 脚本 `load_checkpoint` 函数的 `ckpt = torch.load(weights, map_location=map_location)` 代码改为：`ckpt = torch.load(weights, map_location=map_location, weights_only=False)`。

根据 onnx 解析 sg 的流程如下：

```shell
$ rbcc parse --onnx outputs/yolov6n.onnx --sg outputs/yolov6n.sg
The version of rbcc installed is 1.2.0
2025-05-06 11:41:22 - RBCC - INFO - Start parse 'outputs/yolov6n.onnx' onnx model.
2025-05-06 11:41:24 - RBCC - INFO - ONNX model parsed successfully.
2025-05-06 11:41:24 - RBCC - INFO - Model's input  0: name=images, shape=[1, 640, 640, 3], dtype=float32.
2025-05-06 11:41:24 - RBCC - INFO - Model's output 0: name=outputs, shape=[1, 8400, 85], dtype=float32.
SG IR saved in outputs/yolov6n.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

### 1.1 模型优化

为了提高模型在硬件设备上的推理性能，可以对模型结构进行优化：

```shell
python rewriter_sg_ns.py outputs/yolov6n.sg outputs/yolov6n.sg
```

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `COCO2017_Quantization_100.zip` 到该文件夹内。

对量化校准数据集 COCO2017_Quantization_100.zip 解压，然后执行：

```shell
$ python quantize_sg.py outputs/yolov6n.sg COCO2017_Quantization_100
Quantize Calibration - Histogram: 100sample [00:13, 15.13sample/s]
```

> 该模型普通量化方法精度损失大，因此采用了 `WeightReconQunatizer` 量化方法，减小模型权重在量化过程中因四舍五入导致的量化损失。还对卷积算子采用 Per—Channel 方式量化，
并且对网络输出采用了 16-bit 量化，以保证模型量化精度损失在可接受范围内。具体设置请参考 rbcc 手册量化部分。
> 该示例可用于您集成到代码环境中的参考。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/yolov6n_8bit.sg --rbo outputs/yolov6n.rbo --config env.json
The version of rbcc installed is 1.2.0, librbcc: Not Installed
2025-04-11 14:51:58 - RBCC - INFO - Start loading 'outputs/yolov6n_8bit.sg'.
2025-04-11 14:51:58 - RBCC - INFO - Loading sg end.
2025-04-11 14:51:58 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-11 14:52:30 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/yolov6n.rbo'.
```

`--config env.json` 指定编译优化项，使用后模型性能更佳。

## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

使用 scp 将 `yolov6n.rbo` 上传到 CAISA 430 设备可访问的路径：

```shell
scp outputs/yolov6n.rbo root@192.168.12.169:/data/yolov6n.rbo
```

### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
python demo.py /data/yolov6n.rbo ../../imgs/demo.jpg
```

### 4.2 精度测试

全数据集精度测试：

| Model       | DataSet        | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | -------------- | ------ | -------------------- | ----------------- |
| YOLOv6n     | COCO2017(5k)   |  fp32  | 37.4                 |  53.0             |
| YOLOv6n-sg  | COCO2017(5k)   |  uint8 | 36.7                 |  52.5             |
| YOLOv6n-rbo | COCO2017(5k)   |  uint8 | 36.0                 |  51.9             |

部分数据集精度测试（前 500 imgs）：

| Model       | DataSet         | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| ----------- | --------------- | ------ | -------------------- | ----------------- |
| YOLOv6n     | COCO2017(500)   |  fp32  | 42.1                 |  57.3             |
| YOLOv6n-sg  | COCO2017(500)   |  uint8 | 41.0                 |  56.6             |
| YOLOv6n-rbo | COCO2017(500)   |  uint8 | 41.0                 |  56.4             |

该模型使用 COCO2017 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── COCO2017
    ├── annotations             # 图片标签
    └── val2017                 # 测试图片, 共 5000 张
```

评估方式如下：

```shell
python ../../tools/eval_coco.py \
    /data/yolov6n.rbo \
    --preprocess-py preprocess.py \
    --data ~/datasets/COCO2017 \
    --yolo-coco \
    --device-id 0 \
    --eval-nums 5000 \
    --conf 0.03
```

参数介绍：

- `--preprocess-py`：预处理和后处理脚本。
- `--data`：COCO2017 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--yolo-coco`：表示使用 80 个类别的精度评价。
- `--eval-nums`：指定数据集的大小，COCO2017 验证数据集共有 5000 张图片。
- `--conf`：nms 分数阈值参数。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
python ../../tools/eval_coco.py \
    outputs/yolov6n_8bit.sg \
    --preprocess-py preprocess.py \
    --data ~/datasets/COCO2017 \
    --yolo-coco \
    --device-id 0 \
    --eval-nums 5000 \
    --conf 0.03
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

性能测试参考 [rbo 上板测试](../rbo_perf.md)。
