# YOLO-World 部署示例

该示例使用 [yolo-world](https://docs.ultralytics.com/models/yolo-world/) 提供的 [yolov8s-worldv2.pt](https://github.com/ultralytics/assets/releases/download/v8.3.0/yolov8s-worldv2.pt) 预训练权重。

整体步骤如下：

1. 参考 [yolo-world](https://docs.ultralytics.com/models/yolo-world/) 导出 onnx 文件，也可以使用我们已经导出的 onnx 文件。
2. 把 onnx 转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
3. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
4. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
5. 对 rbo 进行性能测试和精度测试。

**目录**

- [YOLO-World 部署示例](#yolo-world-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 单张图像测试](#41-单张图像测试)
    - [4.2 精度测试](#42-精度测试)
    - [4.3 性能测试](#43-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017_Quantization_100.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/COCO2017.zip)
3. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/yolov8s-worldv2.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/yolov8s_worldv2_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/yolov8s_worldv2.rbo)

## 1. 模型转换

RBCC 支持 ONNX 模型格式作为输入导出 sg，可以从[模型与数据集下载](#0-模型与数据集下载)提供的链接下载 `yolov8s-worldv2.onnx` 至该文件夹内，也可以选择自行导出 onnx 模型，onnx 模型导出方法如下：

```shell
pip install ultralytics
python export_onnx.py yolov8s-worldv2.pt
```

从 onnx 模型导出 sg：

```shell
$ mkdir outputs
$ rbcc parse --onnx yolov8s-worldv2.onnx --sg outputs/yolov8s_worldv2.sg 
The version of rbcc installed is 1.2.0
2025-05-06 18:17:06 - RBCC - INFO - Start parse 'yolov8s-worldv2.onnx' onnx model.
2025-05-06 18:17:08 - RBCC - INFO - ONNX model parsed successfully.
2025-05-06 18:17:08 - RBCC - INFO - Model's input  0: name=images, shape=[1, 640, 640, 3], dtype=float32.
2025-05-06 18:17:08 - RBCC - INFO - Model's output 0: name=output0, shape=[1, 84, 8400], dtype=float32.
SG IR saved in outputs/yolov8s_worldv2.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

针对 YOLO-world 的 Einsum 计算，我们进行了硬件相关的优化，可以直接改为 Matmul 计算，从而可以在硬件上的运行。优化方式如下：

```shell
python rewriter_sg.py outputs/yolov8s_worldv2.sg
```

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先从[模型与数据集下载](#0-模型与数据集下载)提供的链接中下载量化校准数据集 `COCO2017_Quantization_100.zip` 到该文件夹内。

对量化校准数据集 COCO2017_Quantization_100.zip 解压，然后执行：

```shell
$ python quantize_sg.py outputs/yolov8s_worldv2.sg COCO2017_Quantization_100
Quantize Calibration - Histogram: 100sample [00:04, 20.10sample/s]
```

> 该模型普通量化方法精度损失大，因此采用了 `WeightReconQunatizer` 量化方法，减小模型权重在量化过程中因四舍五入导致的量化损失。还对卷积算子采用 Per—Channel 方式量化，并且对网络输出采用了 16-bit 量化，以保证模型量化精度损失在可接受范围内。具体设置请参考 rbcc 手册量化部分。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/yolov8s_worldv2_8bit.sg --rbo outputs/yolov8s_worldv2.rbo --config env.json
The version of rbcc installed is 1.2.0
2025-04-29 11:15:49 - RBCC - INFO - Start loading 'outputs/yolov8s_worldv2_8bit.sg'.
2025-04-29 11:15:49 - RBCC - INFO - Loading sg end.
2025-04-29 11:15:49 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-29 11:15:52 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/yolov8s_worldv2.rbo'.
```

`--config env.json` 指定编译优化项，使用后模型性能更佳。

## 4. 模型测试

成功编译生成 rbo 后，我们需要在 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

使用 scp 将 `yolov8s_worldv2.rbo` 上传到 CAISA 430 设备可访问的路径：

```shell
scp outputs/yolov8s_worldv2.rbo root@192.168.12.169:/data/yolov8s_worldv2.rbo
```

### 4.1 单张图像测试

通过远程调用，我们也可以快速测试 rbo 单张图片的结果：

```shell
python demo.py /data/yolov8s_worldv2.rbo ../../imgs/demo.jpg
```

### 4.2 精度测试

全数据集精度测试：

| Model               | DataSet        | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| -----------         | -------------- | ------ | -------------------- | ----------------- |
| Yolov8s-Worldv2     | COCO2017(5k)   |  fp32  | 37.4                 | 52.0              |
| Yolov8s-Worldv2-sg  | COCO2017(5k)   |  uint8 | 36.4                 | 51.0              |
| Yolov8s-Worldv2-rbo | COCO2017(5k)   |  uint8 | 36.0                 | 50.7              |

部分数据集精度测试（前 500 imgs）：

| Model               | DataSet          | dtype  | mAP<sup>val<br>50-95 | mAP<sup>val<br>50 |
| -----------         | ---------------  | ------ | -------------------- | ----------------- |
| Yolov8s-Worldv2     | COCO2017(500)    |  fp32  | 41.0                 | 54.7              |
| Yolov8s-Worldv2-sg  | COCO2017(500)    |  uint8 | 40.7                 | 54.5              |
| Yolov8s-Worldv2-rbo | COCO2017(500)    |  uint8 | 40.3                 | 54.4              |   

该模型使用 COCO2017 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── COCO2017
    ├── val2017                 # 测试图片, 共 5000 张
    └── annotations             # 标签
```

评估方式如下：

```shell
# scp rbo 到硬件设备上
python ../../tools/eval_coco.py \
      /data/yolov8s_worldv2.rbo \
      --preprocess-py preprocess.py \
      --data ./COCO2017 \
      --device-id 0  \
      --yolo-coco \
      --eval-nums 5000 \
      --conf 0.001
```

> 评估前，确保 yolov8s_worldv2.rbo 已经 scp 到 430 系列盒子上，并且容器是可以访问到的路径。

参数介绍：

- `--preprocess-py`：前后处理脚本。
- `--data`：COCO2017 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--yolo-coco`：表示使用 80 个类别的精度评价。
- `--eval-nums`：指定数据集的大小，COCO2017 验证数据集共用 5000 张图片。
- `--conf`：nms 分数阈值参数。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
python ../../tools/eval_coco.py outputs/yolov8s_worldv2_8bit.sg \
      --preprocess-py preprocess.py \
      --data ./COCO2017 \
      --device-id 0  \
      --yolo-coco \
      --eval-nums 5000 \
      --conf 0.001
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.3 性能测试

参考 [rbo 性能测试](../rbo_perf.md)