# PPOCR-REC 部署示例

该示例来自 [PaddleOCR](https://github.com/PaddlePaddle/PaddleOCR) 项目, 权重使用的是 [ch_PP-OCRv4_rec_infer.tar](https://paddleocr.bj.bcebos.com/PP-OCRv4/chinese/ch_PP-OCRv4_rec_infer.tar)。

整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [PPOCR-REC 部署示例](#ppocr-rec-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#41-精度测试)
    - [4.2 性能测试](#42-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准与测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/datasets/ocr_rec_dataset_examples.zip)
2. [onnx 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/ppocr_rec.onnx)
3. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/ppocr_rec_8bit.sg)
4. [PPOCR-REC rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/ppocr_rec.rbo)

## 1. 模型转换

导出 onnx 模型：

```shell
# 开始前请先提前下载好模型权重：https://paddleocr.bj.bcebos.com/PP-OCRv4/chinese/ch_PP-OCRv4_rec_infer.tar 并解压到当前目录下。
$ pip install paddlepaddle==2.6.2 paddle2onnx==1.3.1
$ mkdir outputs
$ paddle2onnx --model_dir ./ch_PP-OCRv4_rec_infer \
    --model_filename inference.pdmodel \
    --params_filename inference.pdiparams \
    --save_file outputs/ppocr_rec.onnx \
    --opset_version 11 \
    --enable_onnx_checker True
$ onnxsim outputs/ppocr_rec.onnx outputs/ppocr_rec.onnx --input-shape 1,3,48,320
```

导出 sg：

```shell
$ rbcc parse --onnx outputs/ppocr_rec.onnx --sg outputs/ppocr_rec.sg
The version of rbcc installed is 1.2.0
2025-04-27 19:14:48 - RBCC - INFO - Start parse 'outputs/ppocr_rec.onnx' onnx model.
2025-04-27 19:14:52 - RBCC - INFO - ONNX model parsed successfully.
2025-04-27 19:14:52 - RBCC - INFO - Model's input  0: name=x, shape=[1, 48, 320, 3], dtype=float32.
2025-04-27 19:14:52 - RBCC - INFO - Model's output 0: name=softmax_11_tmp_0, shape=[1, 40, 6625], dtype=float32.
SG IR saved in outputs/ppocr_rec.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 50 个样本，作为量化校准数据集。在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载数据集。

对数据集 `ocr_rec_dataset_examples.zip` 解压，再对 sg 进行量化, 使用方式如下：

```shell
$ python quantize_sg.py outputs/ppocr_rec.sg ./ocr_rec_dataset_examples
Quantize Calibration - MinMax: 100%|█████████████████████████████| 50/50 [00:09<00:00,  5.48sample/s]
```

该模型量化损失严重，我们采用的是全 16-bit 量化。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/ppocr_rec_8bit.sg --rbo outputs/ppocr_rec.rbo
The version of rbcc installed is 1.2.0
2025-04-27 19:59:43 - RBCC - INFO - Start loading 'outputs/ppocr_rec_8bit.sg'.
2025-04-27 19:59:43 - RBCC - INFO - Loading sg end.
2025-04-27 19:59:43 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-27 19:59:49 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/ppocr_rec.rbo'.
```

## 4. 模型测试

成功编译生成 rbo 后，我们需要在 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用](../rbo_exe.md)。

### 4.1 精度测试

| Model     | DataSet                  | fp32@Acc  | sg-int8@Acc  | rbo-int8@Acc |
| -------   | ----------------------   | ----------| ------------ | ------------ |
| PPOCR-REC | OCR-REC-Dataset_Examples | 66.15     | 66.06        | 66.01        |

该模型使用 ocr_rec_dataset_examples 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，测试集结构如下：

```shell
└── ocr_rec_dataset_examples
    ├── images             # 图片数据     
    ├── ppocr_keys_v1.txt  # 字典 
    ├── train.txt          # 训练集图片名称         
    └── val.txt            # 验证集图片名称
```

评估方式如下：

```shell
# scp rbo 到硬件设备上
$ scp outputs/ppocr_rec.rbo root@192.168.12.169:/data
python eval_acc.py /data/ppocr_rec.rbo --data ./ocr_rec_dataset_examples --device-id 0
```

> 评估前，确保 ppocr_rec.rbo 已经 scp 到 430 系列盒子上，并且容器是可以访问到的路径。

参数介绍：

- `--data`：数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。


若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
python eval_acc.py outputs/ppocr_rec_8bit.sg --data ./ocr_rec_dataset_examples --device-id 0
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.2 性能测试

参考 [rbo 性能测试](../rbo_perf.md)