# Inception 部署示例

该示例使用 [torchvision-inception_v3](https://pytorch.org/vision/stable/models/generated/torchvision.models.inception_v3.html#torchvision.models.inception_v3) 权重。

整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 RBCC 量化 sg 得到 int8 sg。
3. 使用 RBCC 对 int8 sg 进行编译生成可在 CAISA 芯片上执行的 rbo 文件。
4. 拷贝 rbo 文件到 430p 盒子进行性能测试和精度测试。

**目录**

- [Inception 部署示例](#inception-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#41-精度测试)
    - [4.2 性能测试](#42-性能测试)


## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/imagenet2012_Quantization_200.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/imagenet2012_5k.zip)
3. [onnx 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/inception_v3.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/inception_v3_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/inception_v3.rbo)

## 1. 模型转换

导出 onnx 模型：

```shell
$ mkdir outputs
$ python export_onnx.py outputs/inception_v3.onnx
```

把 onnx 模型转换成 sg：

```shell
$ rbcc parse --onnx outputs/inception_v3.onnx --sg outputs/inception_v3.sg 
The version of rbcc installed is 1.2.0
2025-04-28 18:09:17 - RBCC - INFO - Start parse 'outputs/inception_v3.onnx' onnx model.
2025-04-28 18:09:21 - RBCC - INFO - ONNX model parsed successfully.
2025-04-28 18:09:21 - RBCC - INFO - Model's input  0: name=img, shape=[1, 299, 299, 3], dtype=float32.
2025-04-28 18:09:21 - RBCC - INFO - Model's output 0: name=fc2conv2d_flatten__0, shape=[-1, 1000], dtype=float32.
SG IR saved in outputs/inception_v3.sg
```

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载量化校准数据集。

对量化校准数据集 `imagenet2012_Quantization_200.zip` 解压，然后执行：

```shell
$ python quantize_sg.py outputs/inception_v3.sg imagenet2012_Quantization_200/
Quantize Calibration - Histogram: 200sample [00:07, 25.65sample/s]
```

该模型普通量化方法精度损失大，需要使用跨层均衡算法提升量化精度，使用 `use_eq=True` 指定。

> 该脚本默认使用 GPU 量化，无 GPU 环境时请修改脚本中 gpu_id 参数为 -1。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/inception_v3_8bit.sg --rbo outputs/inception_v3.rbo --config env.json 
The version of rbcc installed is 1.2.0
2025-04-28 18:16:14 - RBCC - INFO - Start loading 'outputs/inception_v3_8bit.sg'.
2025-04-28 18:16:14 - RBCC - INFO - Loading sg end.
2025-04-28 18:16:14 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-28 18:16:19 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/inception_v3.rbo'.
```

`--config env.json` 指定编译优化项，使用后模型性能更佳。

此模型可以开启 4-Batch 优化，通过以下命令：

```shell
$ rbcc gen --sg outputs/inception_v3_8bit.sg --rbo outputs/inception_v3_4batch.rbo --config 4_batch_env.json 
The version of rbcc installed is 1.2.0
2025-04-28 15:52:39 - RBCC - INFO - Start loading 'outputs/inception_v3_8bit.sg'.
2025-04-28 15:52:39 - RBCC - INFO - Loading sg end.
2025-04-28 15:52:39 - RBCC - INFO - Start compiling the model and generate rbo.
(tensor<4x224x224x3xf32>) -> tensor<4x1000xf32>
loc("fc2conv2d_flatten__0"): error: type of return operand 0 ('tensor<1x1000xf32>') doesn't match function result type ('tensor<4x1000xf32>') in function @main_graph
2025-04-28 15:52:43 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/resnet50_4batch.rbo'.
```

`4_batch_env.json` 里面配置了 `ENABLE_NBATCH` 编译环境变量，开启 4-Batch 进行 了 BatchLoop 优化。它与导出时指定 Batch 为 4 是不同的。

## 4. 模型测试

成功编译生成 rbo 后，我们需要把 rbo 文件拷贝到 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用文档](../rbo_exe.md)。

### 4.1 精度测试

ImageNet-5K 数据集测试结果如下：

| Model            | DataSet          | Dtype    | Acc@Top-1 | Acc@Top-5 |
| ---------------- | ---------------- | -------- | --------- | --------- |
| Inception-V3     | ImageNet-1K(5k)  | fp32     | 78.04     | 93.68     |
| Inception-V3-sg  | ImageNet-1K(5k)  | uint8    | 77.72     | 93.38     |
| Inception-V3-rbo | ImageNet-1K(5k)  | uint8    | 77.74     | 93.42     |

该模型使用 ImageNet 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，解压后文件结构如下：

```shell
└── imagenet2012_5k
    ├── xxx.JPEG                # 测试图片, 共 5000 张
    └── val.txt                 # 图片分类标签
```

评估方式如下：

```shell
# scp rbo 到硬件设备上
$ scp outputs/inception_v3.rbo root@192.168.12.169:/data
$ python ../../tools/eval_imagenet.py /data/inception_v3.rbo --preprocess-py preprocess.py --data ~/datasets/imagenet2012_5k/ --device-id 0 --batch-size 1
INFO: Init Runner.
INFO: Load model from /data/inception_v3.rbo
INFO: connect to 192.168.12.169:50052
Model uploaded successfully. Model ID: 0c12fd01ae5dc6607935789f1f224189
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in ImageNet-1K: 100%|████████████████████████████████████████| 5000/5000 [37:30<00:00,  2.22img/s]
Top1-Acc: 77.74, Top5-Acc: 93.42
```

> 前面步骤中 rbo 输入的 batch 默认为 1，故这里我们只能指定 batch 为 1

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python ../../tools/eval_imagenet.py outputs/inception_v3_8bit.sg --preprocess-py preprocess.py --data ~/datasets/imagenet2012_5k/ --device-id 0 --batch-size 32
INFO: Init Runner.
INFO: Load model from outputs/inception_v3_8bit.sg
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in ImageNet-1K: 100%|███████████████████████████████████████| 157/157 [00:10<00:00, 15.67img/s]
Top1-Acc: 77.72, Top5-Acc: 93.38
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.2 性能测试

参考 [rbo 性能测试](../rbo_perf.md)
