# DenseNet121 部署示例

该示例使用 [torchvision-densenet121](https://pytorch.org/vision/stable/models/generated/torchvision.models.densenet121.html#torchvision.models.densenet121) 权重。

整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 RBCC 量化 sg 得到 int8 sg。
3. 使用 RBCC 对 int8 sg 进行编译生成可在 CAISA 芯片上执行的 rbo 文件。
4. 拷贝 rbo 文件到 430p 盒子进行性能测试和精度测试。

**目录**

- [DenseNet121 部署示例](#densenet121-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#41-精度测试)
    - [4.2 性能测试](#42-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/imagenet2012_Quantization_200.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/imagenet2012_5k.zip)
3. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/densenet121.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/densenet121_8bit.onnx)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/densenet121.rbo)

## 1. 模型转换

导出 onnx 模型：

```shell
mkdir outputs
$ python export_onnx.py outputs/densenet121.onnx
```

从 onnx 模型导出 sg：

```shell
$ rbcc parse --onnx outputs/densenet121.onnx --sg outputs/densenet121.sg
The version of rbcc installed is 1.2.0
2025-04-29 16:26:57 - RBCC - INFO - Start parse 'outputs/densenet121.onnx' onnx model.
2025-04-29 16:27:02 - RBCC - INFO - ONNX model parsed successfully.
2025-04-29 16:27:02 - RBCC - INFO - Model's input  0: name=img, shape=[1, 224, 224, 3], dtype=float32.
2025-04-29 16:27:02 - RBCC - INFO - Model's output 0: name=fc2conv2d_flatten__0, shape=[-1, 1000], dtype=float32.
SG IR saved in outputs/densenet121.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载量化校准数据集。

对量化校准数据集 `imagenet2012_Quantization_200.zip` 解压，然后执行：

```shell
$ python quantize_sg.py outputs/densenet121.sg imagenet2012_Quantization_200/
Cross-layer equalization (EQ): : 110it [00:16,  6.51it/s]
Quantize Calibration - Histogram: 100%|██████████████████████| 200/200 [00:49<00:00,  4.08sample/s
```

该模型普通量化方法精度损失大，需要使用跨层均衡算法提升量化精度，使用 `use_eq=True` 指定。

> 该脚本默认使用 GPU 量化，无 GPU 环境时请修改脚本中 gpu_id 参数为 -1。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/densenet121_8bit.sg --rbo outputs/densenet121.rbo --config env.json 
The version of rbcc installed is 1.2.0
2025-04-29 16:38:11 - RBCC - INFO - Start loading 'outputs/densenet121_8bit.sg'.
2025-04-29 16:38:11 - RBCC - INFO - Loading sg end.
2025-04-29 16:38:11 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-29 16:38:16 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/densenet121.rbo'.
```

`--config env.json` 指定编译优化项，使用后模型性能更佳。

## 4. 模型测试

成功编译生成 rbo 后，我们需要在 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用文档](../rbo_exe.md)。

### 4.1 精度测试

ImageNet-5K 数据集测试结果如下：

| Model            | DataSet       |  Dtype   | Acc@Top-1  | Acc@Top-5 |
| ---------------- | ------------- | -------- | ---------- | --------- |
| DenseNet121      | ImageNet(5K)  |  fp32    | 75.08      | 92.18     |
| DenseNet121-sg   | ImageNet(5K)  |  uint8   | 74.34      | 91.70     |
| DenseNet121-rbo  | ImageNet(5K)  |  uint8   | 74.46      | 91.88     |

该模型使用 ImageNet 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，解压后文件结构如下：

```shell
└── imagenet2012_5k
    ├── xxx.JPEG                # 测试图片, 共 5000 张
    └── val.txt                 # 图片分类标签
```

评估方式如下：

```shell
# scp rbo 到硬件设备上
$ scp outputs/densenet121.rbo root@192.168.12.169:/data
$ python ../../tools/eval_imagenet.py /data/densenet121.rbo --preprocess-py preprocess.py --data ~/datasets/imagenet2012_5k/ --device-id 0 --batch-size 1
INFO: Init Runner.
INFO: Load model from /data/densenet121.rbo
INFO: connect to 192.168.12.169:50052
Model uploaded successfully. Model ID: ce6de112904fa55610915fc0c964db6c
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in ImageNet-1K: 100%|███████████████████████████████████| 5000/5000 [04:17<00:00, 19.41img/s]
Top1-Acc: 74.46, Top5-Acc: 91.88
```

> 评估前，确保 densenet121.rbo 已经 scp 到 430 系列盒子上，并且容器是可以访问到的路径。

参数介绍：

- `/data/densenet121.rbo`: 硬件盒子上的 rbo 路径，非当前编译环境下的路径。
- `--preprocess-py`：前处理脚本。
- `--data`：imagenet2012_5k 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--batch-size`：Batch Size 大小。

> 前面步骤中 rbo 输入的 batch 默认为 1，故这里我们只能指定 batch 为 1。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg。它作为 rbo 的编译输入，它的精度是 rbo 精度的模拟结果，sg 精度测试方式如下：

```shell
$ python ../../tools/eval_imagenet.py outputs/densenet121_8bit.sg --preprocess-py preprocess.py --data ~/datasets/imagenet2012_5k/ --device-id 0 --batch-size 32
INFO: Init Runner.
INFO: Load model from outputs/densenet121_8bit.sg
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in ImageNet-1K: 100%|█████████████████████████████████| 157/157 [00:15<00:00, 10.45img/s]
Top1-Acc: 74.34, Top5-Acc: 91.70
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.2 性能测试

参考 [rbo 性能测试](../rbo_perf.md)
