# DeiT 部署示例

该示例使用 [facebook/deit-small-patch16-224](https://huggingface.co/facebook/deit-small-patch16-224) 权重。

整体步骤如下：

1. 导出 ONNX 模型并转换成 SG-IR(以下简称 sg 文件)，用于后续步骤的量化和编译。
2. 准备量化校准数据集，使用 rbcc 量化 sg 得到量化后的 sg。
3. 使用 rbcc 对量化后的 sg 进行编译，生成可在 CAISA 芯片上执行的 rbo 文件。
4. 对 rbo 进行性能测试和精度测试。

**目录**

- [DeiT 部署示例](#deit-部署示例)
  - [0. 模型与数据集下载](#0-模型与数据集下载)
  - [1. 模型转换](#1-模型转换)
  - [2. 模型量化](#2-模型量化)
  - [3. 模型编译](#3-模型编译)
  - [4. 模型测试](#4-模型测试)
    - [4.1 精度测试](#41-精度测试)
    - [4.2 性能测试](#42-性能测试)

## 0. 模型与数据集下载

为了快速体验 CAISA 430 芯片，我们预先提供了预编译好的 sg、onnx 和 rbo 文件，您可选择快速从任一步骤开始。

1. [量化校准数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/imagenet2012_Quantization_200.zip)
2. [测试数据集](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/imagenet2012_5k.zip)
3. [ONNX 模型](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/onnxs/deit_small.onnx)
4. [量化后的 sg](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/sgs/deit_small_8bit.sg)
5. [rbo](https://modelzoo.oss-cn-shenzhen.aliyuncs.com/rbos/deit_small.rbo)

## 1. 模型转换

开始前，可以配置 hugging face 镜像 加速访问，方式如下：

```shell
export HF_ENDPOINT=https://hf-mirror.com
```

导出 onnx 模型：

```shell
$ mkdir outputs
$ python export_onnx.py outputs/deit_small.onnx
```

从 onnx 模型导出 sg：

```shell
$ rbcc parse --onnx outputs/deit_small.onnx --sg outputs/deit_small.sg
The version of rbcc installed is 1.2.0
2025-04-29 17:28:46 - RBCC - INFO - Start parse 'outputs/deit_small.onnx' onnx model.
2025-04-29 17:28:56 - RBCC - INFO - ONNX model parsed successfully.
2025-04-29 17:28:56 - RBCC - INFO - Model's input  0: name=img, shape=[1, 224, 224, 3], dtype=float32.
2025-04-29 17:28:56 - RBCC - INFO - Model's output 0: name=1281, shape=[1, 1000], dtype=float32.
SG IR saved in outputs/deit_small.sg
```

> 注：rbcc parse 命令行默认会对输入 [Batch, Channel, Height, Width] 转换成 [Batch, Height, Width, Channel] 格式。

## 2. 模型量化

在量化操作之前，我们需要从训练数据集中随机抽取 100 至 200 个样本，作为量化校准数据集。在进行量化前请先在[模型与数据集下载](#0-模型与数据集下载)中下载量化校准数据集。

对量化校准数据集 `imagenet2012_Quantization_200.zip` 解压，然后执行：

```shell
$ python quantize_sg.py outputs/deit_small.sg imagenet2012_Quantization_200/
Quantize Calibration - EMA: 100%|██████████████████████| 200/200 [00:37<00:00,  5.28sample/s]
```

deit 模型量化时需要指定残差连接（shortcut）不量化，以保证模型量化精度损失在可接受范围内，在 SG-IR 中，残差连接是 `Eltwise` 算子，我们通过传入 `qconfig` 参数指定，具体用法请参考 rbcc 手册量化部分使用文档。同时为了提高精度，我们也使用了 [smoothquant](https://github.com/mit-han-lab/smoothquant) 量化算法对激活和权重进行量化均衡。

## 3. 模型编译

获得量化后的 sg 后，使用 `rbcc gen` 即可快速完成 rbo 编译：

```shell
$ rbcc gen --sg outputs/deit_small_8bit.sg --rbo outputs/deit_small.rbo --config env.json 
The version of rbcc installed is 1.2.0
2025-04-29 17:36:30 - RBCC - INFO - Start loading 'outputs/deit_small_8bit.sg'.
2025-04-29 17:36:30 - RBCC - INFO - Loading sg end.
2025-04-29 17:36:30 - RBCC - INFO - Start compiling the model and generate rbo.
2025-04-29 17:36:36 - RBCC - INFO - Compilation is completed, rbo has been saved to 'outputs/deit_small.rbo'.
```

`--config env.json` 指定编译优化项，使用后模型性能更佳。

## 4. 模型测试

成功编译生成 rbo 后，我们需要在 CAISA 430 芯片上进行精度测试和性能测试。以下精度评估使用了远程调用的方式，环境准备参考 [rbo 远程调用文档](../rbo_exe.md)。

### 4.1 精度测试

ImageNet-5K 数据集测试结果如下：

| Model           | DataSet       |  Dtype   | Acc@Top-1  | Acc@Top-5 |
| --------------- | ------------- | -------- | ---------- | --------- |
| deit_small      | ImageNet(5K)  |  fp32    | 80.66      | 94.90     |
| deit_small-sg   | ImageNet(5K)  |  uint8   | 80.16      | 94.92     |
| deit_small-rbo  | ImageNet(5K)  |  uint8   | 80.08      | 95.08     |

该模型使用 ImageNet 数据集进行精度评估，请先在[模型与数据集下载](#0-模型与数据集下载)中下载测试数据集，解压后文件结构如下：

```shell
└── imagenet2012_5k
    ├── xxx.JPEG                # 测试图片, 共 5000 张
    └── val.txt                 # 图片分类标签
```

评估方式如下：

```shell
# scp rbo 到硬件设备上
$ scp outputs/deit_small.rbo root@192.168.12.169:/data
$ python ../../tools/eval_imagenet.py /data/deit_small.rbo --data ~/datasets/imagenet2012_5k/ --preprocess-py preprocess.py --device-id 0 --batch-size 1
INFO: Init Runner.
INFO: Load model from /data/deit_small.rbo
INFO: connect to 192.168.12.169:50052
Model uploaded successfully. Model ID: 0a8cfe78e6fec3d4cf7085a22d9a9e65
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in ImageNet-1K: 100%|██████████████████████████████████████████████████████| 5000/5000 [21:02<00:00,  3.96img/s]
Top1-Acc: 80.08, Top5-Acc: 95.08
```

参数介绍：

- `--preprocess-py`：前后处理脚本。
- `--data`imagenet2012_5k 数据集文件夹路径。
- `--device-id`：输入为 rbo 时，表示指定 CAISA 430 芯片引擎 id，它默认有 2 个引擎，分别使用 0 和 1 表示。输入为 sg 时，表示指定 GPU 设备 id，cpu 推理请指定 -1。
- `--batch-size`：模型输入 Batch 大小。

> 前面步骤中 rbo 输入的 batch 默认为 1，故这里我们只能指定 batch 为 1。

若 rbo 精度相比原浮点模型精度下降过多，无法确定具体原因时，我们建议先测试 sg，它作为 rbo 的编译输入，它的结果也至关重要，sg 精度测试方式如下：

```shell
$ python ../../tools/eval_imagenet.py outputs/deit_small.sg --data ~/datasets/imagenet2012_5k/ --preprocess-py preprocess.py --device-id 0 --batch-size 1
INFO: Init Runner.
INFO: Load model from outputs/deit_small.sg
INFO: Load preprocess.
INFO: Load dataset.
INFO: Start inference.
Eval in ImageNet-1K: 100%|█████████████████████████████| 5000/5000 [01:54<00:00, 43.76img/s]
Top1-Acc: 80.66, Top5-Acc: 94.90
```

> sg 使用 Pytorch 作为运行后端，并模拟量化计算过程，故其精度和 rbo 精度会有些许区别，这属于正常现象。

### 4.2 性能测试

参考 [rbo 性能测试](../rbo_perf.md)。
